/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.array;

import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.basictypecontainer.array.FakeArray;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.array.ArrayCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.label.FakeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayLocalizableCursor<T extends Type<T>>
extends ArrayCursor<T>
implements LocalizableCursor<T> {
    protected final int numDimensions;
    protected final int[] position;
    protected final int[] dimensions;

    public ArrayLocalizableCursor(Array<T, ?> array, Image<T> image, T t) {
        super(array, image, t);
        this.numDimensions = array.getNumDimensions();
        this.position = new int[this.numDimensions];
        this.dimensions = array.getDimensions();
        this.reset();
    }

    public static ArrayLocalizableCursor<FakeType> createLinearCursor(int[] nArray) {
        Array array = new Array(null, new FakeArray(), nArray, 1);
        return new ArrayLocalizableCursor<FakeType>(array, null, new FakeType());
    }

    @Override
    public void fwd() {
        this.type.incIndex();
        for (int i = 0; i < this.numDimensions; ++i) {
            if (this.position[i] >= this.dimensions[i] - 1) continue;
            int n = i;
            this.position[n] = this.position[n] + 1;
            for (int j = 0; j < i; ++j) {
                this.position[j] = 0;
            }
            return;
        }
    }

    @Override
    public void fwd(long l) {
        for (long i = 0L; i < l; ++i) {
            this.fwd();
        }
    }

    @Override
    public void reset() {
        if (this.dimensions == null) {
            return;
        }
        this.isClosed = false;
        this.type.updateIndex(-1);
        this.position[0] = -1;
        for (int i = 1; i < this.numDimensions; ++i) {
            this.position[i] = 0;
        }
        this.type.updateContainer(this);
    }

    @Override
    public void getPosition(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            nArray[i] = this.position[i];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.position.clone();
    }

    @Override
    public int getPosition(int n) {
        return this.position[n];
    }

    @Override
    public String getPositionAsString() {
        String string = "(" + this.position[0];
        for (int i = 1; i < this.numDimensions; ++i) {
            string = string + ", " + this.position[i];
        }
        string = string + ")";
        return string;
    }

    @Override
    public String toString() {
        return this.getPositionAsString() + " = " + this.getType();
    }
}

