/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.array;

import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategy;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayLocalizableByDimOutOfBoundsCursor<T extends Type<T>>
extends ArrayLocalizableByDimCursor<T>
implements LocalizableByDimCursor<T> {
    final OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory;
    final OutOfBoundsStrategy<T> outOfBoundsStrategy;
    boolean isOutOfBounds = false;

    public ArrayLocalizableByDimOutOfBoundsCursor(Array<T, ?> array, Image<T> image, T t, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        super(array, image, t);
        this.outOfBoundsStrategyFactory = outOfBoundsStrategyFactory;
        this.outOfBoundsStrategy = outOfBoundsStrategyFactory.createStrategy(this);
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return !this.isOutOfBounds && this.type.getIndex() < this.maxIndex;
    }

    @Override
    public void reset() {
        if (this.outOfBoundsStrategy == null) {
            return;
        }
        this.isClosed = false;
        this.isOutOfBounds = false;
        this.type.updateIndex(-1);
        this.position[0] = -1;
        for (int i = 1; i < this.numDimensions; ++i) {
            this.position[i] = 0;
        }
        this.type.updateContainer(this);
    }

    @Override
    public T getType() {
        if (this.isOutOfBounds) {
            return this.outOfBoundsStrategy.getType();
        }
        return (T)this.type;
    }

    @Override
    public void fwd() {
        if (!this.isOutOfBounds) {
            this.type.incIndex();
            for (int i = 0; i < this.numDimensions; ++i) {
                if (this.position[i] >= this.dimensions[i] - 1) continue;
                int n = i;
                this.position[n] = this.position[n] + 1;
                for (int j = 0; j < i; ++j) {
                    this.position[j] = 0;
                }
                return;
            }
            this.isOutOfBounds = true;
            this.position[0] = this.position[0] + 1;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void fwd(int n) {
        int n2 = n;
        this.position[n2] = this.position[n2] + 1;
        if (this.isOutOfBounds) {
            if (this.position[n] == 0) {
                this.setPosition(this.position);
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOundsFwd(n);
            }
        } else if (this.position[n] < this.dimensions[n]) {
            this.type.incIndex(this.step[n]);
        } else {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void move(int n, int n2) {
        int n3 = n2;
        this.position[n3] = this.position[n3] + n;
        if (this.isOutOfBounds) {
            if (this.position[n2] >= 0 && this.position[n2] < this.dimensions[n2]) {
                this.isOutOfBounds = false;
                for (int i = 0; i < this.numDimensions && !this.isOutOfBounds; ++i) {
                    if (this.position[i] >= 0 && this.position[i] < this.dimensions[i]) continue;
                    this.isOutOfBounds = true;
                }
                if (!this.isOutOfBounds) {
                    this.type.updateContainer(this);
                    this.type.updateIndex(this.container.getPos(this.position));
                } else {
                    this.outOfBoundsStrategy.notifyOutOfBOunds(n, n2);
                }
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOunds(n, n2);
            }
        } else if (this.position[n2] >= 0 && this.position[n2] < this.dimensions[n2]) {
            this.type.incIndex(this.step[n2] * n);
        } else {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void bck(int n) {
        int n2 = n;
        this.position[n2] = this.position[n2] - 1;
        if (this.isOutOfBounds) {
            if (this.position[n] == this.dimensions[n] - 1) {
                this.setPosition(this.position);
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOundsBck(n);
            }
        } else if (this.position[n] > -1) {
            this.type.decIndex(this.step[n]);
        } else {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void setPosition(int[] nArray) {
        boolean bl = this.isOutOfBounds;
        this.isOutOfBounds = false;
        for (int i = 0; i < this.numDimensions; ++i) {
            this.position[i] = nArray[i];
            if (nArray[i] >= 0 && nArray[i] < this.dimensions[i]) continue;
            this.isOutOfBounds = true;
        }
        if (this.isOutOfBounds) {
            if (bl) {
                this.outOfBoundsStrategy.notifyOutOfBOunds();
            } else {
                this.outOfBoundsStrategy.initOutOfBOunds();
            }
        } else {
            if (bl) {
                this.type.updateContainer(this);
            }
            this.type.updateIndex(this.container.getPos(nArray));
        }
    }

    @Override
    public void setPosition(int n, int n2) {
        this.position[n2] = n;
        if (this.isOutOfBounds || this.type.getIndex() == -1) {
            this.setPosition(this.position);
        } else {
            if (n < 0 || n >= this.dimensions[n2]) {
                this.isOutOfBounds = true;
                this.outOfBoundsStrategy.initOutOfBOunds();
                return;
            }
            this.type.updateIndex(this.container.getPos(this.position));
        }
    }
}

