/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.array;

import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.basictypecontainer.array.FakeArray;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursorFactory;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.label.FakeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayLocalizableByDimCursor<T extends Type<T>>
extends ArrayLocalizableCursor<T>
implements LocalizableByDimCursor<T> {
    protected final int[] step;
    final int[] tmp;
    int numNeighborhoodCursors = 0;

    public ArrayLocalizableByDimCursor(Array<T, ?> array, Image<T> image, T t) {
        super(array, image, t);
        this.step = Array.createAllocationSteps(array.getDimensions());
        this.tmp = new int[this.numDimensions];
    }

    public static ArrayLocalizableByDimCursor<FakeType> createLinearByDimCursor(int[] nArray) {
        Array array = new Array(null, new FakeArray(), nArray, 1);
        return new ArrayLocalizableByDimCursor<FakeType>(array, null, new FakeType());
    }

    @Override
    public synchronized LocalNeighborhoodCursor<T> createLocalNeighborhoodCursor() {
        if (this.numNeighborhoodCursors == 0) {
            ++this.numNeighborhoodCursors;
            return LocalNeighborhoodCursorFactory.createLocalNeighborhoodCursor(this);
        }
        System.out.println("ArrayLocalizableByDimCursor.createLocalNeighborhoodCursor(): There is only one one special cursor per cursor allowed.");
        return null;
    }

    @Override
    public synchronized RegionOfInterestCursor<T> createRegionOfInterestCursor(int[] nArray, int[] nArray2) {
        if (this.numNeighborhoodCursors == 0) {
            ++this.numNeighborhoodCursors;
            return new RegionOfInterestCursor(this, nArray, nArray2);
        }
        System.out.println("ArrayLocalizableByDimCursor.createRegionOfInterestCursor(): There is only one special cursor per cursor allowed.");
        return null;
    }

    @Override
    public void fwd(int n) {
        this.type.incIndex(this.step[n]);
        int n2 = n;
        this.position[n2] = this.position[n2] + 1;
    }

    @Override
    public void move(int n, int n2) {
        this.type.incIndex(this.step[n2] * n);
        int n3 = n2;
        this.position[n3] = this.position[n3] + n;
    }

    @Override
    public void bck(int n) {
        this.type.decIndex(this.step[n]);
        int n2 = n;
        this.position[n2] = this.position[n2] - 1;
    }

    @Override
    public void moveRel(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            this.move(nArray[i], i);
        }
    }

    @Override
    public void moveTo(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            int n = nArray[i] - this.getPosition(i);
            if (n == 0) continue;
            this.move(n, i);
        }
    }

    @Override
    public void moveTo(Localizable localizable) {
        localizable.getPosition(this.tmp);
        this.moveTo(this.tmp);
    }

    @Override
    public void setPosition(Localizable localizable) {
        localizable.getPosition(this.tmp);
        this.setPosition(this.tmp);
    }

    @Override
    public void setPosition(int[] nArray) {
        this.type.updateIndex(this.container.getPos(nArray));
        for (int i = 0; i < this.numDimensions; ++i) {
            this.position[i] = nArray[i];
        }
    }

    @Override
    public void setPosition(int n, int n2) {
        this.position[n2] = n;
        this.type.updateIndex(this.container.getPos(this.position));
    }
}

