/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.array;

import mpicbg.imglib.container.array.Array3D;
import mpicbg.imglib.cursor.LocalizableCursor3D;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Array3DLocalizableCursor<T extends Type<T>>
extends ArrayLocalizableCursor<T>
implements LocalizableCursor3D<T> {
    protected int x = -1;
    protected int y = 0;
    protected int z = 0;
    final int widthMinus1;
    final int heightMinus1;
    final int depthMinus1;
    final int width;
    final int height;
    final int depth;
    final Array3D<T, ?> container;

    public Array3DLocalizableCursor(Array3D<T, ?> array3D, Image<T> image, T t) {
        super(array3D, image, t);
        this.container = array3D;
        this.width = array3D.getWidth();
        this.height = array3D.getHeight();
        this.depth = array3D.getDepth();
        this.widthMinus1 = this.width - 1;
        this.heightMinus1 = this.height - 1;
        this.depthMinus1 = this.depth - 1;
    }

    @Override
    public void fwd() {
        this.type.incIndex();
        if (this.x < this.widthMinus1) {
            ++this.x;
        } else if (this.y < this.heightMinus1) {
            this.x = 0;
            ++this.y;
        } else {
            this.x = 0;
            this.y = 0;
            ++this.z;
        }
    }

    @Override
    public void fwd(long l) {
        if (l <= 0L) {
            return;
        }
        this.type.incIndex((int)l);
        int n = this.type.getIndex();
        this.z = n / (this.width * this.height);
        this.y = (n -= this.z * this.width * this.height) / this.width;
        this.x = n -= this.y * this.width;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public void reset() {
        this.isClosed = false;
        this.x = -1;
        this.z = 0;
        this.y = 0;
        this.type.updateIndex(-1);
        this.type.updateContainer(this);
    }

    @Override
    public void getPosition(int[] nArray) {
        nArray[0] = this.x;
        nArray[1] = this.y;
        nArray[2] = this.z;
    }

    @Override
    public Array3D<T, ?> getStorageContainer() {
        return this.container;
    }

    @Override
    public int[] getPosition() {
        return new int[]{this.x, this.y, this.z};
    }

    @Override
    public int getPosition(int n) {
        if (n == 0) {
            return this.x;
        }
        if (n == 1) {
            return this.y;
        }
        if (n == 2) {
            return this.z;
        }
        System.err.println("Array3DLocalizableCursor.getPosition( int dim ): There is no dimension " + n);
        return -1;
    }

    @Override
    public String getPositionAsString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }
}

