/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.array;

import mpicbg.imglib.container.array.Array3D;
import mpicbg.imglib.cursor.LocalizableByDimCursor3D;
import mpicbg.imglib.cursor.array.ArrayLocalizableByDimOutOfBoundsCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Array3DLocalizableByDimOutOfBoundsCursor<T extends Type<T>>
extends ArrayLocalizableByDimOutOfBoundsCursor<T>
implements LocalizableByDimCursor3D<T> {
    protected int x = -1;
    protected int y = 0;
    protected int z = 0;
    final int widthMinus1;
    final int heightMinus1;
    final int depthMinus1;
    final int width;
    final int height;
    final int depth;
    final int stepY;
    final int stepZ;
    final Array3D<T, ?> container;

    public Array3DLocalizableByDimOutOfBoundsCursor(Array3D<T, ?> array3D, Image<T> image, T t, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        super(array3D, image, t, outOfBoundsStrategyFactory);
        this.container = array3D;
        this.widthMinus1 = array3D.getWidth() - 1;
        this.heightMinus1 = array3D.getHeight() - 1;
        this.depthMinus1 = array3D.getDepth() - 1;
        this.width = array3D.getWidth();
        this.height = array3D.getHeight();
        this.depth = array3D.getDepth();
        this.stepY = array3D.getWidth();
        this.stepZ = array3D.getWidth() * array3D.getHeight();
        this.reset();
    }

    @Override
    public void fwd() {
        if (!this.isOutOfBounds) {
            this.type.incIndex();
            if (this.x < this.widthMinus1) {
                ++this.x;
            } else if (this.y < this.heightMinus1) {
                this.x = 0;
                ++this.y;
            } else if (this.z < this.depthMinus1) {
                this.x = 0;
                this.y = 0;
                ++this.z;
            } else {
                this.isOutOfBounds = true;
                ++this.x;
                this.outOfBoundsStrategy.initOutOfBOunds();
            }
        }
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public void reset() {
        if (this.outOfBoundsStrategy == null) {
            return;
        }
        this.isOutOfBounds = false;
        this.isClosed = false;
        this.x = -1;
        this.z = 0;
        this.y = 0;
        this.type.updateIndex(-1);
        this.type.updateContainer(this);
    }

    @Override
    public void getPosition(int[] nArray) {
        nArray[0] = this.x;
        nArray[1] = this.y;
        nArray[2] = this.z;
    }

    @Override
    public Array3D<T, ?> getStorageContainer() {
        return this.container;
    }

    @Override
    public int[] getPosition() {
        return new int[]{this.x, this.y, this.z};
    }

    @Override
    public int getPosition(int n) {
        if (n == 0) {
            return this.x;
        }
        if (n == 1) {
            return this.y;
        }
        if (n == 2) {
            return this.z;
        }
        System.err.println("Array3DLocalizableByDimOutOfBoundsCursor.getPosition( int dim ): There is no dimension " + n);
        return -1;
    }

    @Override
    public void fwd(int n) {
        if (n == 0) {
            this.fwdX();
        } else if (n == 1) {
            this.fwdY();
        } else if (n == 2) {
            this.fwdZ();
        } else {
            System.err.println("Array3DLocalizableByDimOutOfBoundsCursor.fwd( int dim ): There is no dimension " + n);
        }
    }

    @Override
    public void fwdX() {
        if (this.isOutOfBounds) {
            if (this.x == -1) {
                this.setPositionX(0);
            } else {
                ++this.x;
                this.outOfBoundsStrategy.notifyOutOfBOundsFwd(0);
            }
        } else if (this.x < this.widthMinus1) {
            this.type.incIndex();
            ++this.x;
        } else {
            ++this.x;
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void fwdY() {
        if (this.isOutOfBounds) {
            if (this.y == -1) {
                this.setPositionY(0);
            } else {
                ++this.y;
                this.outOfBoundsStrategy.notifyOutOfBOundsFwd(1);
            }
        } else if (this.y < this.heightMinus1) {
            this.type.incIndex(this.stepY);
            ++this.y;
        } else {
            ++this.y;
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void fwdZ() {
        if (this.isOutOfBounds) {
            if (this.z == -1) {
                this.setPositionZ(0);
            } else {
                ++this.z;
                this.outOfBoundsStrategy.notifyOutOfBOundsFwd(2);
            }
        } else if (this.z < this.depthMinus1) {
            this.type.incIndex(this.stepZ);
            ++this.z;
        } else {
            ++this.z;
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void move(int n, int n2) {
        if (n2 == 0) {
            this.moveX(n);
        } else if (n2 == 1) {
            this.moveY(n);
        } else if (n2 == 2) {
            this.moveZ(n);
        } else {
            System.err.println("Array3DLocalizableByDimOutOfBoundsCursor.move( int dim ): There is no dimension " + n2);
        }
    }

    @Override
    public void moveRel(int n, int n2, int n3) {
        this.moveX(n);
        this.moveY(n2);
        this.moveZ(n3);
    }

    @Override
    public void moveTo(int n, int n2, int n3) {
        this.moveX(n - this.x);
        this.moveY(n2 - this.y);
        this.moveZ(n3 - this.z);
    }

    @Override
    public void moveX(int n) {
        this.x += n;
        if (this.isOutOfBounds) {
            if (this.x > -1 && this.x < this.width) {
                if (this.y < 0 || this.y >= this.height || this.z < 0 || this.z >= this.depth) {
                    this.outOfBoundsStrategy.notifyOutOfBOunds(n, 0);
                } else {
                    this.type.updateIndex(this.container.getPos(this.x, this.y, this.z));
                    this.type.updateContainer(this);
                    this.isOutOfBounds = false;
                }
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOunds(n, 0);
            }
        } else if (this.x > -1 && this.x < this.width) {
            this.type.incIndex(n);
        } else {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void moveY(int n) {
        this.y += n;
        if (this.isOutOfBounds) {
            if (this.y > -1 && this.y < this.height) {
                if (this.x < 0 || this.x >= this.width || this.z < 0 || this.z >= this.depth) {
                    this.outOfBoundsStrategy.notifyOutOfBOunds(n, 1);
                } else {
                    this.type.updateIndex(this.container.getPos(this.x, this.y, this.z));
                    this.type.updateContainer(this);
                    this.isOutOfBounds = false;
                }
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOunds(n, 1);
            }
        } else if (this.y > -1 && this.y < this.height) {
            this.type.incIndex(n * this.stepY);
        } else {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void moveZ(int n) {
        this.z += n;
        if (this.isOutOfBounds) {
            if (this.z > -1 && this.z < this.depth) {
                if (this.y < 0 || this.y >= this.height || this.x < 0 || this.x >= this.width) {
                    this.outOfBoundsStrategy.notifyOutOfBOunds(n, 2);
                } else {
                    this.type.updateIndex(this.container.getPos(this.x, this.y, this.z));
                    this.type.updateContainer(this);
                    this.isOutOfBounds = false;
                }
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOunds(n, 2);
            }
        } else if (this.z > -1 && this.z < this.depth) {
            this.type.incIndex(n * this.stepZ);
        } else {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void bck(int n) {
        if (n == 0) {
            this.bckX();
        } else if (n == 1) {
            this.bckY();
        } else if (n == 2) {
            this.bckZ();
        } else {
            System.err.println("Array3DLocalizableByDimCursor.bck( int dim ): There is no dimension " + n);
        }
    }

    @Override
    public void bckX() {
        if (this.isOutOfBounds) {
            if (this.x == this.width) {
                this.setPositionX(this.widthMinus1);
            } else {
                --this.x;
                this.outOfBoundsStrategy.notifyOutOfBOundsBck(0);
            }
        } else {
            --this.x;
            if (this.x > -1) {
                this.type.decIndex();
            } else {
                this.isOutOfBounds = true;
                this.outOfBoundsStrategy.initOutOfBOunds();
            }
        }
    }

    @Override
    public void bckY() {
        if (this.isOutOfBounds) {
            if (this.y == this.height) {
                this.setPositionY(this.heightMinus1);
            } else {
                --this.y;
                this.outOfBoundsStrategy.notifyOutOfBOundsBck(1);
            }
        } else {
            --this.y;
            if (this.y > -1) {
                this.type.decIndex(this.stepY);
            } else {
                this.isOutOfBounds = true;
                this.outOfBoundsStrategy.initOutOfBOunds();
            }
        }
    }

    @Override
    public void bckZ() {
        if (this.isOutOfBounds) {
            if (this.z == this.depth) {
                this.setPositionZ(this.depthMinus1);
            } else {
                --this.z;
                this.outOfBoundsStrategy.notifyOutOfBOundsBck(2);
            }
        } else {
            --this.z;
            if (this.z > -1) {
                this.type.decIndex(this.stepZ);
            } else {
                this.isOutOfBounds = true;
                this.outOfBoundsStrategy.initOutOfBOunds();
            }
        }
    }

    @Override
    public void setPosition(int[] nArray) {
        this.setPosition(nArray[0], nArray[1], nArray[2]);
    }

    @Override
    public void setPosition(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        if (n > -1 && n < this.width && n2 > -1 && n2 < this.height && n3 > -1 && n3 < this.depth) {
            this.type.updateIndex(this.container.getPos(this.x, this.y, this.z));
            if (this.isOutOfBounds) {
                this.type.updateContainer(this);
            }
            this.isOutOfBounds = false;
        } else if (this.isOutOfBounds) {
            this.outOfBoundsStrategy.notifyOutOfBOunds();
        } else {
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void setPositionX(int n) {
        if (this.isOutOfBounds || this.type.getIndex() == -1) {
            this.setPosition(n, this.y, this.z);
        } else if (n > -1 && n < this.width) {
            this.type.incIndex(n - this.x);
            this.x = n;
        } else {
            this.x = n;
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void setPositionY(int n) {
        if (this.isOutOfBounds || this.type.getIndex() == -1) {
            this.setPosition(this.x, n, this.z);
        } else if (n > -1 && n < this.height) {
            this.type.incIndex((n - this.y) * this.stepY);
            this.y = n;
        } else {
            this.y = n;
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void setPositionZ(int n) {
        if (this.isOutOfBounds || this.type.getIndex() == -1) {
            this.setPosition(this.x, this.y, n);
        } else if (n > -1 && n < this.depth) {
            this.type.incIndex((n - this.z) * this.stepZ);
            this.z = n;
        } else {
            this.z = n;
            this.isOutOfBounds = true;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void setPosition(int n, int n2) {
        if (n2 == 0) {
            this.setPositionX(n);
        } else if (n2 == 1) {
            this.setPositionY(n);
        } else if (n2 == 2) {
            this.setPositionZ(n);
        } else {
            System.err.println("Array3DLocalizableByDimOutOfBoundsCursor.setPosition( int dim ): There is no dimension " + n2);
        }
    }

    @Override
    public String getPositionAsString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }
}

