/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.array;

import mpicbg.imglib.container.array.Array3D;
import mpicbg.imglib.cursor.LocalizableByDimCursor3D;
import mpicbg.imglib.cursor.array.ArrayLocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Array3DLocalizableByDimCursor<T extends Type<T>>
extends ArrayLocalizableByDimCursor<T>
implements LocalizableByDimCursor3D<T> {
    protected int x = -1;
    protected int y = 0;
    protected int z = 0;
    final int widthMinus1;
    final int heightMinus1;
    final int depthMinus1;
    final int width;
    final int height;
    final int depth;
    final int stepY;
    final int stepZ;
    final Array3D<T, ?> container;

    public Array3DLocalizableByDimCursor(Array3D<T, ?> array3D, Image<T> image, T t) {
        super(array3D, image, t);
        this.container = array3D;
        this.width = array3D.getWidth();
        this.height = array3D.getHeight();
        this.depth = array3D.getDepth();
        this.widthMinus1 = this.width - 1;
        this.heightMinus1 = this.height - 1;
        this.depthMinus1 = this.depth - 1;
        this.stepY = array3D.getWidth();
        this.stepZ = array3D.getWidth() * array3D.getHeight();
        this.reset();
    }

    @Override
    public void fwd() {
        this.type.incIndex();
        if (this.x < this.widthMinus1) {
            ++this.x;
        } else if (this.y < this.heightMinus1) {
            this.x = 0;
            ++this.y;
        } else {
            this.x = 0;
            this.y = 0;
            ++this.z;
        }
    }

    @Override
    public void fwd(long l) {
        if (l <= 0L) {
            return;
        }
        this.type.incIndex((int)l);
        int n = this.type.getIndex();
        this.z = n / (this.width * this.height);
        this.y = (n -= this.z * this.width * this.height) / this.width;
        this.x = n -= this.y * this.width;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public void reset() {
        this.isClosed = false;
        this.x = -1;
        this.z = 0;
        this.y = 0;
        this.type.updateIndex(-1);
        this.type.updateContainer(this);
    }

    @Override
    public void getPosition(int[] nArray) {
        nArray[0] = this.x;
        nArray[1] = this.y;
        nArray[2] = this.z;
    }

    @Override
    public Array3D<T, ?> getStorageContainer() {
        return this.container;
    }

    @Override
    public int[] getPosition() {
        return new int[]{this.x, this.y, this.z};
    }

    @Override
    public int getPosition(int n) {
        if (n == 0) {
            return this.x;
        }
        if (n == 1) {
            return this.y;
        }
        if (n == 2) {
            return this.z;
        }
        System.err.println("Array3DLocalizableByDimCursor.getPosition( int dim ): There is no dimension " + n);
        return -1;
    }

    @Override
    public void fwd(int n) {
        if (n == 0) {
            this.fwdX();
        } else if (n == 1) {
            this.fwdY();
        } else if (n == 2) {
            this.fwdZ();
        } else {
            System.err.println("Array3DLocalizableByDimCursor.fwd( int dim ): There is no dimension " + n);
        }
    }

    @Override
    public void fwdX() {
        this.type.incIndex();
        ++this.x;
    }

    @Override
    public void fwdY() {
        this.type.incIndex(this.stepY);
        ++this.y;
    }

    @Override
    public void fwdZ() {
        this.type.incIndex(this.stepZ);
        ++this.z;
    }

    @Override
    public void move(int n, int n2) {
        if (n2 == 0) {
            this.moveX(n);
        } else if (n2 == 1) {
            this.moveY(n);
        } else if (n2 == 2) {
            this.moveZ(n);
        } else {
            System.err.println("Array3DLocalizableByDimCursor.move( int dim ): There is no dimension " + n2);
        }
    }

    @Override
    public void moveRel(int n, int n2, int n3) {
        this.moveX(n);
        this.moveY(n2);
        this.moveZ(n3);
    }

    @Override
    public void moveTo(int n, int n2, int n3) {
        this.moveX(n - this.x);
        this.moveY(n2 - this.y);
        this.moveZ(n3 - this.z);
    }

    @Override
    public void moveX(int n) {
        this.type.incIndex(n);
        this.x += n;
    }

    @Override
    public void moveY(int n) {
        this.type.incIndex(n * this.stepY);
        this.y += n;
    }

    @Override
    public void moveZ(int n) {
        this.type.incIndex(n * this.stepZ);
        this.z += n;
    }

    @Override
    public void bck(int n) {
        if (n == 0) {
            this.bckX();
        } else if (n == 1) {
            this.bckY();
        } else if (n == 2) {
            this.bckZ();
        } else {
            System.err.println("Array3DLocalizableByDimCursor.bck( int dim ): There is no dimension " + n);
        }
    }

    @Override
    public void bckX() {
        this.type.decIndex();
        --this.x;
    }

    @Override
    public void bckY() {
        this.type.decIndex(this.stepY);
        --this.y;
    }

    @Override
    public void bckZ() {
        this.type.decIndex(this.stepZ);
        --this.z;
    }

    @Override
    public void setPosition(int[] nArray) {
        this.setPosition(nArray[0], nArray[1], nArray[2]);
    }

    @Override
    public void setPosition(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.type.updateIndex(this.container.getPos(this.x, this.y, this.z));
    }

    @Override
    public void setPositionX(int n) {
        this.type.incIndex(n - this.x);
        this.x = n;
    }

    @Override
    public void setPositionY(int n) {
        this.type.incIndex((n - this.y) * this.stepY);
        this.y = n;
    }

    @Override
    public void setPositionZ(int n) {
        this.type.incIndex((n - this.z) * this.stepZ);
        this.z = n;
    }

    @Override
    public void setPosition(int n, int n2) {
        if (n2 == 0) {
            this.setPositionX(n);
        } else if (n2 == 1) {
            this.setPositionY(n);
        } else if (n2 == 2) {
            this.setPositionZ(n);
        } else {
            System.err.println("Array3DLocalizableByDimCursor.setPosition( int dim ): There is no dimension " + n2);
        }
    }

    @Override
    public String getPositionAsString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }
}

