/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor;

import java.util.Iterator;
import mpicbg.imglib.container.Container;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CursorImpl<T extends Type<T>>
implements Cursor<T> {
    protected final Image<T> image;
    protected final Container<T> container;
    protected boolean isClosed = false;
    protected boolean debug = false;

    public CursorImpl(Container<T> container, Image<T> image) {
        this.image = image;
        this.container = container;
    }

    @Override
    public Iterator<T> iterator() {
        this.reset();
        return this;
    }

    @Override
    public int getArrayIndex() {
        return this.getType().getIndex();
    }

    @Override
    public Image<T> getImage() {
        return this.image;
    }

    @Override
    public Container<T> getStorageContainer() {
        return this.container;
    }

    @Override
    public boolean isActive() {
        return !this.isClosed;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public void remove() {
    }

    @Override
    public T next() {
        this.fwd();
        return this.getType();
    }

    @Override
    public void fwd(long l) {
        for (long i = 0L; i < l; ++i) {
            this.fwd();
        }
    }

    @Override
    public int[] createPositionArray() {
        return new int[this.image.getNumDimensions()];
    }

    @Override
    public int getNumDimensions() {
        return this.image.getNumDimensions();
    }

    @Override
    public int[] getDimensions() {
        return this.image.getDimensions();
    }

    @Override
    public void getDimensions(int[] nArray) {
        this.image.getDimensions(nArray);
    }
}

