/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.shapelist;

import java.awt.Shape;
import java.util.ArrayList;
import mpicbg.imglib.container.Container;
import mpicbg.imglib.container.ContainerImpl;
import mpicbg.imglib.container.shapelist.ShapeListContainerFactory;
import mpicbg.imglib.cursor.shapelist.ShapeListLocalizableByDimCursor;
import mpicbg.imglib.cursor.shapelist.ShapeListLocalizableByDimOutOfBoundsCursor;
import mpicbg.imglib.cursor.shapelist.ShapeListLocalizablePlaneCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeList<T extends Type<T>>
extends ContainerImpl<T> {
    public final ShapeListContainerFactory factory;
    protected final ArrayList<ArrayList<Shape>> shapeLists;
    protected final ArrayList<ArrayList<T>> typeLists;
    protected final T background;

    public ShapeList(ShapeListContainerFactory shapeListContainerFactory, int[] nArray, T t) {
        super(shapeListContainerFactory, nArray);
        int n;
        this.factory = shapeListContainerFactory;
        int n2 = 1;
        for (n = 2; n < nArray.length; ++n) {
            n2 *= nArray[n];
        }
        this.shapeLists = new ArrayList(n2);
        this.typeLists = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            this.shapeLists.add(new ArrayList());
            this.typeLists.add(new ArrayList());
        }
        this.background = t;
    }

    public ShapeList(int[] nArray, T t) {
        this(new ShapeListContainerFactory(), nArray, t);
    }

    public T getBackground() {
        return this.background;
    }

    public synchronized void addShape(Shape shape, T t, int[] nArray) {
        int n = 0;
        if (nArray != null) {
            int n2 = 1;
            for (int i = 2; i < this.numDimensions; ++i) {
                n += n2 * nArray[i - 2];
                n2 *= this.dim[i];
            }
        }
        this.shapeLists.get(n).add(shape);
        this.typeLists.get(n).add(t);
    }

    public synchronized ArrayList<ArrayList<Shape>> getShapeLists() {
        ArrayList<ArrayList<Shape>> arrayList = new ArrayList<ArrayList<Shape>>();
        for (ArrayList<Shape> arrayList2 : this.shapeLists) {
            arrayList.add(new ArrayList<Shape>(arrayList2));
        }
        return arrayList;
    }

    @Override
    public ShapeListContainerFactory getFactory() {
        return this.factory;
    }

    @Override
    public ShapeListLocalizableByDimCursor<T> createCursor(Image<T> image) {
        return this.createLocalizableByDimCursor((Image)image);
    }

    @Override
    public ShapeListLocalizableByDimCursor<T> createLocalizableCursor(Image<T> image) {
        return this.createLocalizableByDimCursor((Image)image);
    }

    @Override
    public ShapeListLocalizablePlaneCursor<T> createLocalizablePlaneCursor(Image<T> image) {
        return new ShapeListLocalizablePlaneCursor<T>(this, image);
    }

    @Override
    public ShapeListLocalizableByDimCursor<T> createLocalizableByDimCursor(Image<T> image) {
        return new ShapeListLocalizableByDimCursor<T>(this, image);
    }

    @Override
    public ShapeListLocalizableByDimOutOfBoundsCursor<T> createLocalizableByDimCursor(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        return new ShapeListLocalizableByDimOutOfBoundsCursor<T>(this, image, outOfBoundsStrategyFactory);
    }

    @Override
    public void close() {
    }

    protected T getShapeType(int n, int n2, int n3) {
        ArrayList<Shape> arrayList = this.shapeLists.get(n3);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            if (!arrayList.get(i).contains(n, n2)) continue;
            return (T)((Type)this.typeLists.get(n3).get(i));
        }
        return this.background;
    }

    public T getShapeType(int[] nArray) {
        int n = 0;
        int n2 = 1;
        for (int i = 2; i < nArray.length; ++i) {
            n += n2 * nArray[i];
            n2 *= this.dim[i];
        }
        return this.getShapeType(nArray[0], nArray[1], n);
    }

    @Override
    public boolean compareStorageContainerCompatibility(Container<?> container) {
        if (this.compareStorageContainerDimensions(container)) {
            return this.getFactory().getClass().isInstance(container.getFactory());
        }
        return false;
    }
}

