/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.planar;

import java.util.ArrayList;
import mpicbg.imglib.container.Container;
import mpicbg.imglib.container.DirectAccessContainerImpl;
import mpicbg.imglib.container.basictypecontainer.PlanarAccess;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;
import mpicbg.imglib.container.planar.PlanarContainerFactory;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.planar.PlanarCursor;
import mpicbg.imglib.cursor.planar.PlanarCursor2D;
import mpicbg.imglib.cursor.planar.PlanarLocalizableByDimCursor;
import mpicbg.imglib.cursor.planar.PlanarLocalizableByDimOutOfBoundsCursor;
import mpicbg.imglib.cursor.planar.PlanarLocalizableCursor;
import mpicbg.imglib.cursor.planar.PlanarLocalizablePlaneCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanarContainer<T extends Type<T>, A extends ArrayDataAccess<A>>
extends DirectAccessContainerImpl<T, A>
implements PlanarAccess<A> {
    protected final PlanarContainerFactory factory;
    protected final int slices;
    protected final ArrayList<A> mirror;

    public PlanarContainer(int[] nArray, int n) {
        this(new PlanarContainerFactory(), nArray, n);
    }

    protected PlanarContainer(PlanarContainerFactory planarContainerFactory, int[] nArray, int n) {
        this(planarContainerFactory, null, nArray, n);
    }

    PlanarContainer(PlanarContainerFactory planarContainerFactory, A a, int[] nArray, int n) {
        super(planarContainerFactory, nArray, n);
        int n2;
        int n3 = 1;
        for (n2 = 2; n2 < this.numDimensions; ++n2) {
            n3 *= nArray[n2];
        }
        this.slices = n3;
        this.factory = planarContainerFactory;
        this.mirror = new ArrayList(this.slices);
        for (n2 = 0; n2 < this.slices; ++n2) {
            this.mirror.add(a == null ? null : (ArrayDataAccess)a.createArray(this.getDimension(0) * this.getDimension(1) * n));
        }
    }

    @Override
    public A update(Cursor<?> cursor) {
        return (A)((ArrayDataAccess)this.mirror.get(cursor.getStorageIndex()));
    }

    public int getSlices() {
        return this.slices;
    }

    public final int getIndex(int[] nArray) {
        if (this.numDimensions > 1) {
            return nArray[1] * this.dim[0] + nArray[0];
        }
        return nArray[0];
    }

    @Override
    public PlanarCursor<T> createCursor(Image<T> image) {
        if (this.numDimensions == 2) {
            return new PlanarCursor2D<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        }
        return new PlanarCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
    }

    @Override
    public PlanarLocalizableCursor<T> createLocalizableCursor(Image<T> image) {
        return new PlanarLocalizableCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
    }

    @Override
    public PlanarLocalizablePlaneCursor<T> createLocalizablePlaneCursor(Image<T> image) {
        return new PlanarLocalizablePlaneCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
    }

    @Override
    public PlanarLocalizableByDimCursor<T> createLocalizableByDimCursor(Image<T> image) {
        return new PlanarLocalizableByDimCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
    }

    @Override
    public PlanarLocalizableByDimOutOfBoundsCursor<T> createLocalizableByDimCursor(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        return new PlanarLocalizableByDimOutOfBoundsCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer(), outOfBoundsStrategyFactory);
    }

    @Override
    public PlanarContainerFactory getFactory() {
        return this.factory;
    }

    @Override
    public void close() {
        for (ArrayDataAccess arrayDataAccess : this.mirror) {
            arrayDataAccess.close();
        }
    }

    @Override
    public boolean compareStorageContainerCompatibility(Container<?> container) {
        return this.compareStorageContainerDimensions(container) && this.getFactory().getClass().isInstance(container.getFactory());
    }

    @Override
    public A getPlane(int n) {
        return (A)((ArrayDataAccess)this.mirror.get(n));
    }

    @Override
    public void setPlane(int n, A a) {
        this.mirror.set(n, a);
    }
}

