/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.dynamic;

import mpicbg.imglib.container.Container;
import mpicbg.imglib.container.DirectAccessContainerImpl;
import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.dynamic.DynamicContainerAccessor;
import mpicbg.imglib.container.dynamic.DynamicContainerFactory;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizablePlaneCursor;
import mpicbg.imglib.cursor.dynamic.DynamicCursor;
import mpicbg.imglib.cursor.dynamic.DynamicLocalizableByDimCursor;
import mpicbg.imglib.cursor.dynamic.DynamicLocalizableByDimOutOfBoundsCursor;
import mpicbg.imglib.cursor.dynamic.DynamicLocalizableCursor;
import mpicbg.imglib.cursor.dynamic.DynamicLocalizablePlaneCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DynamicContainer<T extends Type<T>, A extends DynamicContainerAccessor>
extends DirectAccessContainerImpl<T, A> {
    protected final int[] step;
    protected int numPixels;
    protected int numEntities;

    public DynamicContainer(DynamicContainerFactory dynamicContainerFactory, int[] nArray, int n) {
        super(dynamicContainerFactory, nArray, n);
        this.step = Array.createAllocationSteps(nArray);
        this.numPixels = ((DirectAccessContainerImpl)this).numPixels;
        this.numEntities = ((DirectAccessContainerImpl)this).numEntities;
    }

    public int[] getSteps() {
        return (int[])this.step.clone();
    }

    public int getStep(int n) {
        return this.step[n];
    }

    public final int getPos(int[] nArray) {
        int n = nArray[0];
        for (int i = 1; i < this.numDimensions; ++i) {
            n += nArray[i] * this.step[i];
        }
        return n;
    }

    public abstract A createAccessor();

    @Override
    public int getNumEntities() {
        return this.numEntities;
    }

    @Override
    public int getNumPixels() {
        return this.numPixels;
    }

    @Override
    public DynamicCursor<T> createCursor(Image<T> image) {
        return new DynamicCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
    }

    @Override
    public LocalizableByDimCursor<T> createLocalizableByDimCursor(Image<T> image) {
        return new DynamicLocalizableByDimCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
    }

    @Override
    public LocalizableByDimCursor<T> createLocalizableByDimCursor(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        return new DynamicLocalizableByDimOutOfBoundsCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer(), outOfBoundsStrategyFactory);
    }

    @Override
    public DynamicLocalizableCursor<T> createLocalizableCursor(Image<T> image) {
        return new DynamicLocalizableCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
    }

    @Override
    public LocalizablePlaneCursor<T> createLocalizablePlaneCursor(Image<T> image) {
        return new DynamicLocalizablePlaneCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
    }

    @Override
    public boolean compareStorageContainerCompatibility(Container<?> container) {
        if (this.compareStorageContainerDimensions(container)) {
            return this.getFactory().getClass().isInstance(container.getFactory());
        }
        return false;
    }
}

