/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.cell;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.array.BitArray;
import mpicbg.imglib.container.basictypecontainer.array.ByteArray;
import mpicbg.imglib.container.basictypecontainer.array.CharArray;
import mpicbg.imglib.container.basictypecontainer.array.DoubleArray;
import mpicbg.imglib.container.basictypecontainer.array.FloatArray;
import mpicbg.imglib.container.basictypecontainer.array.IntArray;
import mpicbg.imglib.container.basictypecontainer.array.LongArray;
import mpicbg.imglib.container.basictypecontainer.array.ShortArray;
import mpicbg.imglib.container.cell.CellContainer;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellContainerFactory
extends DirectAccessContainerFactory {
    protected int[] cellSize;
    protected int standardCellSize = 10;

    public CellContainerFactory() {
    }

    public CellContainerFactory(int n) {
        this.standardCellSize = n;
    }

    public CellContainerFactory(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            System.err.println("CellContainerFactory(): cellSize is null. Using equal cell size of 10.");
            this.cellSize = null;
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] > 0) continue;
            System.err.println("CellContainerFactory(): cell size in dimension " + i + " is <= 0, using a size of " + this.standardCellSize + ".");
            nArray[i] = this.standardCellSize;
        }
        this.cellSize = nArray;
    }

    protected int[] checkDimensions(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            System.err.println("CellContainerFactory(): dimensionality is null. Creating a 1D cell with size 1.");
            nArray = new int[]{1};
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] > 0) continue;
            System.err.println("CellContainerFactory(): size of dimension " + i + " is <= 0, using a size of 1.");
            nArray[i] = 1;
        }
        return nArray;
    }

    protected int[] checkCellSize(int[] nArray, int[] nArray2) {
        if (nArray == null) {
            nArray = new int[nArray2.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.standardCellSize;
            }
            return nArray;
        }
        if (nArray.length != nArray2.length) {
            System.err.println("CellContainerFactory(): dimensionality of image is unequal to dimensionality of cells, adjusting cell dimensionality.");
            int[] nArray3 = new int[nArray2.length];
            for (int i = 0; i < nArray2.length; ++i) {
                nArray3[i] = i < nArray.length ? nArray[i] : this.standardCellSize;
            }
            return nArray3;
        }
        return nArray;
    }

    public <T extends Type<T>> DirectAccessContainer<T, BitArray> createBitInstance(int[] nArray, int n) {
        nArray = this.checkDimensions(nArray);
        int[] nArray2 = this.checkCellSize(this.cellSize, nArray);
        return new CellContainer(this, new BitArray(1), nArray, nArray2, n);
    }

    public <T extends Type<T>> DirectAccessContainer<T, ByteArray> createByteInstance(int[] nArray, int n) {
        nArray = this.checkDimensions(nArray);
        int[] nArray2 = this.checkCellSize(this.cellSize, nArray);
        return new CellContainer(this, new ByteArray(1), nArray, nArray2, n);
    }

    public <T extends Type<T>> DirectAccessContainer<T, CharArray> createCharInstance(int[] nArray, int n) {
        nArray = this.checkDimensions(nArray);
        int[] nArray2 = this.checkCellSize(this.cellSize, nArray);
        return new CellContainer(this, new CharArray(1), nArray, nArray2, n);
    }

    public <T extends Type<T>> DirectAccessContainer<T, DoubleArray> createDoubleInstance(int[] nArray, int n) {
        nArray = this.checkDimensions(nArray);
        int[] nArray2 = this.checkCellSize(this.cellSize, nArray);
        return new CellContainer(this, new DoubleArray(1), nArray, nArray2, n);
    }

    public <T extends Type<T>> DirectAccessContainer<T, FloatArray> createFloatInstance(int[] nArray, int n) {
        nArray = this.checkDimensions(nArray);
        int[] nArray2 = this.checkCellSize(this.cellSize, nArray);
        return new CellContainer(this, new FloatArray(1), nArray, nArray2, n);
    }

    public <T extends Type<T>> DirectAccessContainer<T, IntArray> createIntInstance(int[] nArray, int n) {
        nArray = this.checkDimensions(nArray);
        int[] nArray2 = this.checkCellSize(this.cellSize, nArray);
        return new CellContainer(this, new IntArray(1), nArray, nArray2, n);
    }

    public <T extends Type<T>> DirectAccessContainer<T, LongArray> createLongInstance(int[] nArray, int n) {
        nArray = this.checkDimensions(nArray);
        int[] nArray2 = this.checkCellSize(this.cellSize, nArray);
        return new CellContainer(this, new LongArray(1), nArray, nArray2, n);
    }

    public <T extends Type<T>> DirectAccessContainer<T, ShortArray> createShortInstance(int[] nArray, int n) {
        nArray = this.checkDimensions(nArray);
        int[] nArray2 = this.checkCellSize(this.cellSize, nArray);
        return new CellContainer(this, new ShortArray(1), nArray, nArray2, n);
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public void printProperties() {
    }

    @Override
    public void setParameters(String string) {
    }
}

