/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.cell;

import java.util.ArrayList;
import mpicbg.imglib.container.Container;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.DirectAccessContainerImpl;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;
import mpicbg.imglib.container.cell.Cell;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableByDimCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.cursor.cell.CellCursor;
import mpicbg.imglib.cursor.cell.CellLocalizableByDimCursor;
import mpicbg.imglib.cursor.cell.CellLocalizableByDimOutOfBoundsCursor;
import mpicbg.imglib.cursor.cell.CellLocalizableCursor;
import mpicbg.imglib.cursor.cell.CellLocalizablePlaneCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.label.FakeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellContainer<T extends Type<T>, A extends ArrayDataAccess<A>>
extends DirectAccessContainerImpl<T, A> {
    protected final ArrayList<Cell<T, A>> data;
    protected final int[] numCellsDim;
    protected final int[] cellSize;
    protected final int numCells;

    public CellContainer(ContainerFactory containerFactory, A a, int[] nArray, int[] nArray2, int n) {
        super(containerFactory, nArray, n);
        int n2;
        for (n2 = 0; n2 < this.getNumDimensions(); ++n2) {
            if (nArray2[n2] <= nArray[n2]) continue;
            nArray2[n2] = nArray[n2];
        }
        this.cellSize = nArray2;
        this.numCellsDim = new int[this.getNumDimensions()];
        n2 = 1;
        for (int i = 0; i < this.getNumDimensions(); ++i) {
            this.numCellsDim[i] = (nArray[i] - 1) / nArray2[i] + 1;
            n2 *= this.numCellsDim[i];
        }
        this.numCells = n2;
        this.data = this.createCellArray(this.numCells);
        ArrayLocalizableCursor<FakeType> arrayLocalizableCursor = ArrayLocalizableCursor.createLinearCursor(this.numCellsDim);
        for (int i = 0; i < this.numCells; ++i) {
            arrayLocalizableCursor.fwd();
            int[] nArray3 = new int[this.getNumDimensions()];
            int[] nArray4 = new int[this.getNumDimensions()];
            for (int j = 0; j < this.getNumDimensions(); ++j) {
                nArray3[j] = nArray2[j];
                if (arrayLocalizableCursor.getPosition(j) == this.numCellsDim[j] - 1 && nArray[j] % nArray2[j] != 0) {
                    nArray3[j] = nArray[j] % nArray2[j];
                }
                nArray4[j] = arrayLocalizableCursor.getPosition(j) * nArray2[j];
            }
            this.data.add(this.createCellInstance(a, i, nArray3, nArray4, n));
        }
        arrayLocalizableCursor.close();
    }

    @Override
    public A update(Cursor<?> cursor) {
        return this.data.get(cursor.getStorageIndex()).getData();
    }

    public ArrayList<Cell<T, A>> createCellArray(int n) {
        return new ArrayList<Cell<T, A>>(n);
    }

    public Cell<T, A> createCellInstance(A a, int n, int[] nArray, int[] nArray2, int n2) {
        return new Cell(a, n, nArray, nArray2, n2);
    }

    public Cell<T, A> getCell(int n) {
        return this.data.get(n);
    }

    public int getCellIndex(ArrayLocalizableByDimCursor<FakeType> arrayLocalizableByDimCursor, int[] nArray) {
        arrayLocalizableByDimCursor.setPosition(nArray);
        return arrayLocalizableByDimCursor.getArrayIndex();
    }

    public int getCellIndex(ArrayLocalizableByDimCursor<FakeType> arrayLocalizableByDimCursor, int n, int n2) {
        arrayLocalizableByDimCursor.setPosition(n, n2);
        return arrayLocalizableByDimCursor.getArrayIndex();
    }

    public int[] getCellPosition(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < this.numDimensions; ++i) {
            nArray2[i] = nArray[i] / this.cellSize[i];
        }
        return nArray2;
    }

    public void getCellPosition(int[] nArray, int[] nArray2) {
        for (int i = 0; i < this.numDimensions; ++i) {
            nArray2[i] = nArray[i] / this.cellSize[i];
        }
    }

    public int getCellPosition(int n, int n2) {
        return n / this.cellSize[n2];
    }

    public int getCellIndexFromImageCoordinates(ArrayLocalizableByDimCursor<FakeType> arrayLocalizableByDimCursor, int[] nArray) {
        return this.getCellIndex(arrayLocalizableByDimCursor, this.getCellPosition(nArray));
    }

    public int getNumCells(int n) {
        if (n < this.numDimensions) {
            return this.numCellsDim[n];
        }
        return 1;
    }

    public int getNumCells() {
        return this.numCells;
    }

    public int[] getNumCellsDim() {
        return (int[])this.numCellsDim.clone();
    }

    public int getCellSize(int n) {
        return this.cellSize[n];
    }

    public int[] getCellSize() {
        return (int[])this.cellSize.clone();
    }

    @Override
    public void close() {
        for (Cell<T, A> cell : this.data) {
            cell.close();
        }
    }

    @Override
    public CellCursor<T> createCursor(Image<T> image) {
        CellCursor<T> cellCursor = new CellCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        return cellCursor;
    }

    @Override
    public CellLocalizableCursor<T> createLocalizableCursor(Image<T> image) {
        CellLocalizableCursor<T> cellLocalizableCursor = new CellLocalizableCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        return cellLocalizableCursor;
    }

    @Override
    public CellLocalizablePlaneCursor<T> createLocalizablePlaneCursor(Image<T> image) {
        CellLocalizablePlaneCursor<T> cellLocalizablePlaneCursor = new CellLocalizablePlaneCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        return cellLocalizablePlaneCursor;
    }

    @Override
    public CellLocalizableByDimCursor<T> createLocalizableByDimCursor(Image<T> image) {
        CellLocalizableByDimCursor<T> cellLocalizableByDimCursor = new CellLocalizableByDimCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        return cellLocalizableByDimCursor;
    }

    @Override
    public CellLocalizableByDimCursor<T> createLocalizableByDimCursor(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        CellLocalizableByDimOutOfBoundsCursor<T> cellLocalizableByDimOutOfBoundsCursor = new CellLocalizableByDimOutOfBoundsCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer(), outOfBoundsStrategyFactory);
        return cellLocalizableByDimOutOfBoundsCursor;
    }

    @Override
    public boolean compareStorageContainerCompatibility(Container<?> container) {
        if (this.compareStorageContainerDimensions(container)) {
            if (this.getFactory().getClass().isInstance(container.getFactory())) {
                CellContainer cellContainer = (CellContainer)container;
                for (int i = 0; i < this.numDimensions; ++i) {
                    if (this.getCellSize(i) == cellContainer.getCellSize(i)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

