/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.cell;

import mpicbg.imglib.container.ContainerImpl;
import mpicbg.imglib.container.PixelGridContainerImpl;
import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cell<T extends Type<T>, A extends ArrayDataAccess<A>> {
    protected final int[] offset;
    protected final int[] step;
    protected final int[] dim;
    protected final int cellId;
    protected final int numDimensions;
    protected final int numPixels;
    protected final int numEntities;
    protected final A data;

    public Cell(A a, int n, int[] nArray, int[] nArray2, int n2) {
        this.offset = nArray2;
        this.cellId = n;
        this.numDimensions = nArray.length;
        this.dim = nArray;
        this.numPixels = ContainerImpl.getNumPixels(nArray);
        this.numEntities = PixelGridContainerImpl.getNumEntities(nArray, n2);
        this.step = new int[this.numDimensions];
        this.data = (ArrayDataAccess)a.createArray(this.numEntities);
        Array.createAllocationSteps(nArray, this.step);
    }

    protected A getData() {
        return this.data;
    }

    protected void close() {
        this.data.close();
    }

    public int getNumPixels() {
        return this.numPixels;
    }

    public int getNumEntities() {
        return this.numEntities;
    }

    public void getDimensions(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            nArray[i] = this.dim[i];
        }
    }

    public void getSteps(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            nArray[i] = this.step[i];
        }
    }

    public int getCellId() {
        return this.cellId;
    }

    public void getOffset(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            nArray[i] = this.offset[i];
        }
    }

    public final int getPosGlobal(int[] nArray) {
        int n = nArray[0] - this.offset[0];
        for (int i = 1; i < this.dim.length; ++i) {
            n += (nArray[i] - this.offset[i]) * this.step[i];
        }
        return n;
    }
}

