/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.basictypecontainer.array;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import mpicbg.imglib.container.basictypecontainer.ShortAccess;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NIOShortArray
implements ArrayDataAccess<NIOShortArray>,
ShortAccess {
    protected ShortBuffer data;

    public NIOShortArray(int n) {
        this.data = ByteBuffer.allocateDirect(n * 8).order(ByteOrder.nativeOrder()).asShortBuffer();
    }

    public NIOShortArray(short[] sArray) {
        ShortBuffer shortBuffer = ShortBuffer.wrap(sArray);
        ShortBuffer shortBuffer2 = ByteBuffer.allocateDirect(shortBuffer.capacity()).order(ByteOrder.nativeOrder()).asShortBuffer();
        this.data = shortBuffer2.put(shortBuffer);
    }

    @Override
    public void close() {
        this.data = null;
    }

    @Override
    public short getValue(int n) {
        return this.data.get(n);
    }

    @Override
    public void setValue(int n, short s) {
        this.data.put(n, s);
    }

    public short[] getCurrentStorageArray() {
        short[] sArray = new short[this.data.capacity()];
        this.data.get(sArray);
        return sArray;
    }

    @Override
    public NIOShortArray createArray(int n) {
        return new NIOShortArray(n);
    }
}

