/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.basictypecontainer.array;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import mpicbg.imglib.container.basictypecontainer.LongAccess;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NIOLongArray
implements ArrayDataAccess<NIOLongArray>,
LongAccess {
    protected LongBuffer data;

    public NIOLongArray(int n) {
        this.data = ByteBuffer.allocateDirect(n * 8).order(ByteOrder.nativeOrder()).asLongBuffer();
    }

    public NIOLongArray(long[] lArray) {
        LongBuffer longBuffer = LongBuffer.wrap(lArray);
        LongBuffer longBuffer2 = ByteBuffer.allocateDirect(longBuffer.capacity()).order(ByteOrder.nativeOrder()).asLongBuffer();
        this.data = longBuffer2.put(longBuffer);
    }

    @Override
    public void close() {
        this.data = null;
    }

    @Override
    public long getValue(int n) {
        return this.data.get(n);
    }

    @Override
    public void setValue(int n, long l) {
        this.data.put(n, l);
    }

    public long[] getCurrentStorageArray() {
        long[] lArray = new long[this.data.capacity()];
        this.data.get(lArray);
        return lArray;
    }

    @Override
    public NIOLongArray createArray(int n) {
        return new NIOLongArray(n);
    }
}

