/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.basictypecontainer.array;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import mpicbg.imglib.container.basictypecontainer.IntAccess;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NIOIntArray
implements ArrayDataAccess<NIOIntArray>,
IntAccess {
    protected IntBuffer data;

    public NIOIntArray(int n) {
        this.data = ByteBuffer.allocateDirect(n * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    public NIOIntArray(int[] nArray) {
        IntBuffer intBuffer = IntBuffer.wrap(nArray);
        IntBuffer intBuffer2 = ByteBuffer.allocateDirect(intBuffer.capacity()).order(ByteOrder.nativeOrder()).asIntBuffer();
        this.data = intBuffer2.put(intBuffer);
    }

    @Override
    public void close() {
        this.data = null;
    }

    @Override
    public int getValue(int n) {
        return this.data.get(n);
    }

    @Override
    public void setValue(int n, int n2) {
        this.data.put(n, n2);
    }

    public int[] getCurrentStorageArray() {
        int[] nArray = new int[this.data.capacity()];
        this.data.get(nArray);
        return nArray;
    }

    @Override
    public NIOIntArray createArray(int n) {
        return new NIOIntArray(n);
    }
}

