/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.basictypecontainer.array;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import mpicbg.imglib.container.basictypecontainer.FloatAccess;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NIOFloatArray
implements ArrayDataAccess<NIOFloatArray>,
FloatAccess {
    protected FloatBuffer data;

    public NIOFloatArray(int n) {
        this.data = ByteBuffer.allocateDirect(n * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    public NIOFloatArray(float[] fArray) {
        FloatBuffer floatBuffer = FloatBuffer.wrap(fArray);
        FloatBuffer floatBuffer2 = ByteBuffer.allocateDirect(floatBuffer.capacity()).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.data = floatBuffer2.put(floatBuffer);
    }

    @Override
    public void close() {
        this.data = null;
    }

    @Override
    public float getValue(int n) {
        return this.data.get(n);
    }

    @Override
    public void setValue(int n, float f) {
        this.data.put(n, f);
    }

    public float[] getCurrentStorageArray() {
        float[] fArray = new float[this.data.capacity()];
        this.data.get(fArray);
        return fArray;
    }

    @Override
    public NIOFloatArray createArray(int n) {
        return new NIOFloatArray(n);
    }
}

