/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.basictypecontainer.array;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import mpicbg.imglib.container.basictypecontainer.DoubleAccess;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NIODoubleArray
implements ArrayDataAccess<NIODoubleArray>,
DoubleAccess {
    protected DoubleBuffer data;

    public NIODoubleArray(int n) {
        this.data = ByteBuffer.allocateDirect(n * 8).order(ByteOrder.nativeOrder()).asDoubleBuffer();
    }

    public NIODoubleArray(double[] dArray) {
        DoubleBuffer doubleBuffer = DoubleBuffer.wrap(dArray);
        DoubleBuffer doubleBuffer2 = ByteBuffer.allocateDirect(doubleBuffer.capacity()).order(ByteOrder.nativeOrder()).asDoubleBuffer();
        this.data = doubleBuffer2.put(doubleBuffer);
    }

    @Override
    public void close() {
        this.data = null;
    }

    @Override
    public double getValue(int n) {
        return this.data.get(n);
    }

    @Override
    public void setValue(int n, double d) {
        this.data.put(n, d);
    }

    public double[] getCurrentStorageArray() {
        double[] dArray = new double[this.data.capacity()];
        this.data.get(dArray);
        return dArray;
    }

    @Override
    public NIODoubleArray createArray(int n) {
        return new NIODoubleArray(n);
    }
}

