/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.basictypecontainer.array;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import mpicbg.imglib.container.basictypecontainer.CharAccess;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NIOCharArray
implements ArrayDataAccess<NIOCharArray>,
CharAccess {
    protected CharBuffer data;

    public NIOCharArray(int n) {
        this.data = ByteBuffer.allocateDirect(n * 4).order(ByteOrder.nativeOrder()).asCharBuffer();
    }

    public NIOCharArray(char[] cArray) {
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        CharBuffer charBuffer2 = ByteBuffer.allocateDirect(charBuffer.capacity()).order(ByteOrder.nativeOrder()).asCharBuffer();
        this.data = charBuffer2.put(charBuffer);
    }

    @Override
    public void close() {
        this.data = null;
    }

    @Override
    public char getValue(int n) {
        return this.data.get(n);
    }

    @Override
    public void setValue(int n, char c) {
        this.data.put(n, c);
    }

    public char[] getCurrentStorageArray() {
        char[] cArray = new char[this.data.capacity()];
        this.data.get(cArray);
        return cArray;
    }

    @Override
    public NIOCharArray createArray(int n) {
        return new NIOCharArray(n);
    }
}

