/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.basictypecontainer.array;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import mpicbg.imglib.container.basictypecontainer.ByteAccess;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NIOByteArray
implements ArrayDataAccess<NIOByteArray>,
ByteAccess {
    protected ByteBuffer data;

    public NIOByteArray(int n) {
        this.data = ByteBuffer.allocateDirect(n * 4).order(ByteOrder.nativeOrder());
    }

    public NIOByteArray(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(byteBuffer.capacity()).order(ByteOrder.nativeOrder());
        this.data = byteBuffer2.put(byteBuffer);
    }

    @Override
    public void close() {
        this.data = null;
    }

    @Override
    public byte getValue(int n) {
        return this.data.get(n);
    }

    @Override
    public void setValue(int n, byte by) {
        this.data.put(n, by);
    }

    public byte[] getCurrentStorageArray() {
        byte[] byArray = new byte[this.data.capacity()];
        this.data.get(byArray);
        return byArray;
    }

    @Override
    public NIOByteArray createArray(int n) {
        return new NIOByteArray(n);
    }
}

