/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.basictypecontainer.array;

import mpicbg.imglib.container.basictypecontainer.BitAccess;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitArray
implements BitAccess,
ArrayDataAccess<BitArray> {
    static final int bitsPerEntity = 32;
    final int numEntities;
    protected int[] data;

    public BitArray(int n) {
        this.numEntities = n;
        int n2 = this.numEntities % 32 == 0 ? this.numEntities / 32 : this.numEntities / 32 + 1;
        this.data = new int[n2];
    }

    @Override
    public void close() {
        this.data = null;
    }

    @Override
    public boolean getValue(int n) {
        int n2 = n / 32;
        int n3 = this.data[n2];
        int n4 = n % 32;
        int n5 = n3 & 1 << n4;
        return n5 != 0;
    }

    @Override
    public void setValue(int n, boolean bl) {
        int n2 = n / 32;
        int n3 = n % 32;
        this.data[n2] = bl ? this.data[n2] | 1 << n3 : this.data[n2] & ~(1 << n3);
    }

    public int[] getCurrentStorageArray() {
        return this.data;
    }

    @Override
    public BitArray createArray(int n) {
        return new BitArray(n);
    }
}

