/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.array;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.PixelGridContainerImpl;
import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.array.Array3D;
import mpicbg.imglib.container.basictypecontainer.BitAccess;
import mpicbg.imglib.container.basictypecontainer.ByteAccess;
import mpicbg.imglib.container.basictypecontainer.CharAccess;
import mpicbg.imglib.container.basictypecontainer.DoubleAccess;
import mpicbg.imglib.container.basictypecontainer.FloatAccess;
import mpicbg.imglib.container.basictypecontainer.IntAccess;
import mpicbg.imglib.container.basictypecontainer.LongAccess;
import mpicbg.imglib.container.basictypecontainer.ShortAccess;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;
import mpicbg.imglib.container.basictypecontainer.array.BitArray;
import mpicbg.imglib.container.basictypecontainer.array.ByteArray;
import mpicbg.imglib.container.basictypecontainer.array.CharArray;
import mpicbg.imglib.container.basictypecontainer.array.DoubleArray;
import mpicbg.imglib.container.basictypecontainer.array.FloatArray;
import mpicbg.imglib.container.basictypecontainer.array.IntArray;
import mpicbg.imglib.container.basictypecontainer.array.LongArray;
import mpicbg.imglib.container.basictypecontainer.array.NIOByteArray;
import mpicbg.imglib.container.basictypecontainer.array.NIOCharArray;
import mpicbg.imglib.container.basictypecontainer.array.NIODoubleArray;
import mpicbg.imglib.container.basictypecontainer.array.NIOFloatArray;
import mpicbg.imglib.container.basictypecontainer.array.NIOIntArray;
import mpicbg.imglib.container.basictypecontainer.array.NIOLongArray;
import mpicbg.imglib.container.basictypecontainer.array.NIOShortArray;
import mpicbg.imglib.container.basictypecontainer.array.ShortArray;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayContainerFactory
extends DirectAccessContainerFactory {
    protected boolean useNIO = false;

    public void setNIOUse(boolean bl) {
        this.useNIO = bl;
    }

    public boolean useNIO() {
        return this.useNIO;
    }

    public <T extends Type<T>> DirectAccessContainer<T, BitAccess> createBitInstance(int[] nArray, int n) {
        if (this.useNIO) {
            throw new IllegalStateException("Cannot create NIO bit arrays");
        }
        int n2 = PixelGridContainerImpl.getNumEntities(nArray, n);
        BitArray bitArray = new BitArray(n2);
        if (nArray.length == 3 && this.useOptimizedContainers) {
            return new Array3D(this, bitArray, nArray[0], nArray[1], nArray[2], n);
        }
        return new Array(this, bitArray, nArray, n);
    }

    public <T extends Type<T>> DirectAccessContainer<T, ByteAccess> createByteInstance(int[] nArray, int n) {
        int n2 = PixelGridContainerImpl.getNumEntities(nArray, n);
        ByteAccess byteAccess = this.useNIO ? new NIOByteArray(n2) : new ByteArray(n2);
        if (nArray.length == 3 && this.useOptimizedContainers) {
            return new Array3D(this, (NIOByteArray)byteAccess, nArray[0], nArray[1], nArray[2], n);
        }
        return new Array(this, (NIOByteArray)byteAccess, nArray, n);
    }

    public <T extends Type<T>> DirectAccessContainer<T, CharAccess> createCharInstance(int[] nArray, int n) {
        int n2 = PixelGridContainerImpl.getNumEntities(nArray, n);
        ArrayDataAccess<NIOCharArray> arrayDataAccess = this.useNIO ? new NIOCharArray(n2) : new CharArray(n2);
        if (nArray.length == 3 && this.useOptimizedContainers) {
            return new Array3D(this, (NIOCharArray)arrayDataAccess, nArray[0], nArray[1], nArray[2], n);
        }
        return new Array(this, (NIOCharArray)arrayDataAccess, nArray, n);
    }

    public <T extends Type<T>> DirectAccessContainer<T, DoubleAccess> createDoubleInstance(int[] nArray, int n) {
        int n2 = PixelGridContainerImpl.getNumEntities(nArray, n);
        ArrayDataAccess<NIODoubleArray> arrayDataAccess = this.useNIO ? new NIODoubleArray(n2) : new DoubleArray(n2);
        if (nArray.length == 3 && this.useOptimizedContainers) {
            return new Array3D(this, (NIODoubleArray)arrayDataAccess, nArray[0], nArray[1], nArray[2], n);
        }
        return new Array(this, (NIODoubleArray)arrayDataAccess, nArray, n);
    }

    public <T extends Type<T>> DirectAccessContainer<T, FloatAccess> createFloatInstance(int[] nArray, int n) {
        int n2 = PixelGridContainerImpl.getNumEntities(nArray, n);
        ArrayDataAccess<NIOFloatArray> arrayDataAccess = this.useNIO ? new NIOFloatArray(n2) : new FloatArray(n2);
        if (nArray.length == 3 && this.useOptimizedContainers) {
            return new Array3D(this, (NIOFloatArray)arrayDataAccess, nArray[0], nArray[1], nArray[2], n);
        }
        return new Array(this, (NIOFloatArray)arrayDataAccess, nArray, n);
    }

    public <T extends Type<T>> DirectAccessContainer<T, IntAccess> createIntInstance(int[] nArray, int n) {
        int n2 = PixelGridContainerImpl.getNumEntities(nArray, n);
        IntAccess intAccess = this.useNIO ? new NIOIntArray(n2) : new IntArray(n2);
        if (nArray.length == 3 && this.useOptimizedContainers) {
            return new Array3D(this, (NIOIntArray)intAccess, nArray[0], nArray[1], nArray[2], n);
        }
        return new Array(this, (NIOIntArray)intAccess, nArray, n);
    }

    public <T extends Type<T>> DirectAccessContainer<T, LongAccess> createLongInstance(int[] nArray, int n) {
        int n2 = PixelGridContainerImpl.getNumEntities(nArray, n);
        LongAccess longAccess = this.useNIO ? new NIOLongArray(n2) : new LongArray(n2);
        if (nArray.length == 3 && this.useOptimizedContainers) {
            return new Array3D(this, (NIOLongArray)longAccess, nArray[0], nArray[1], nArray[2], n);
        }
        return new Array(this, (NIOLongArray)longAccess, nArray, n);
    }

    public <T extends Type<T>> DirectAccessContainer<T, ShortAccess> createShortInstance(int[] nArray, int n) {
        int n2 = PixelGridContainerImpl.getNumEntities(nArray, n);
        ShortAccess shortAccess = this.useNIO ? new NIOShortArray(n2) : new ShortArray(n2);
        if (nArray.length == 3 && this.useOptimizedContainers) {
            return new Array3D(this, (NIOShortArray)shortAccess, nArray[0], nArray[1], nArray[2], n);
        }
        return new Array(this, (NIOShortArray)shortAccess, nArray, n);
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public void printProperties() {
    }

    @Override
    public void setParameters(String string) {
    }
}

