/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.array;

import mpicbg.imglib.container.Container3D;
import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.container.basictypecontainer.DataAccess;
import mpicbg.imglib.cursor.array.Array3DLocalizableByDimCursor;
import mpicbg.imglib.cursor.array.Array3DLocalizableByDimOutOfBoundsCursor;
import mpicbg.imglib.cursor.array.Array3DLocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Array3D<T extends Type<T>, A extends DataAccess>
extends Array<T, A>
implements Container3D<T> {
    final int width;
    final int height;
    final int depth;

    public Array3D(ArrayContainerFactory arrayContainerFactory, A a, int n, int n2, int n3, int n4) {
        super(arrayContainerFactory, a, new int[]{n, n2, n3}, n4);
        this.width = this.dim[0];
        this.height = this.dim[1];
        this.depth = this.dim[2];
    }

    @Override
    public Array3DLocalizableCursor<T> createLocalizableCursor(Image<T> image) {
        Array3DLocalizableCursor<T> array3DLocalizableCursor = new Array3DLocalizableCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        return array3DLocalizableCursor;
    }

    @Override
    public Array3DLocalizableByDimCursor<T> createLocalizableByDimCursor(Image<T> image) {
        Array3DLocalizableByDimCursor<T> array3DLocalizableByDimCursor = new Array3DLocalizableByDimCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        return array3DLocalizableByDimCursor;
    }

    @Override
    public Array3DLocalizableByDimOutOfBoundsCursor<T> createLocalizableByDimCursor(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        Array3DLocalizableByDimOutOfBoundsCursor<T> array3DLocalizableByDimOutOfBoundsCursor = new Array3DLocalizableByDimOutOfBoundsCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer(), outOfBoundsStrategyFactory);
        return array3DLocalizableByDimOutOfBoundsCursor;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    public int getPos(int n, int n2, int n3) {
        return n + this.width * (n2 + n3 * this.height);
    }
}

