/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.array;

import mpicbg.imglib.container.Container;
import mpicbg.imglib.container.DirectAccessContainerImpl;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.container.basictypecontainer.DataAccess;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.array.ArrayCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableByDimCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableByDimOutOfBoundsCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizablePlaneCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Array<T extends Type<T>, A extends DataAccess>
extends DirectAccessContainerImpl<T, A> {
    protected final int[] step;
    final ArrayContainerFactory factory;
    final A data;

    public Array(ArrayContainerFactory arrayContainerFactory, A a, int[] nArray, int n) {
        super(arrayContainerFactory, nArray, n);
        this.step = Array.createAllocationSteps(nArray);
        this.factory = arrayContainerFactory;
        this.data = a;
    }

    @Override
    public A update(Cursor<?> cursor) {
        return this.data;
    }

    @Override
    public ArrayContainerFactory getFactory() {
        return this.factory;
    }

    @Override
    public ArrayCursor<T> createCursor(Image<T> image) {
        ArrayCursor<T> arrayCursor = new ArrayCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        return arrayCursor;
    }

    @Override
    public ArrayLocalizableCursor<T> createLocalizableCursor(Image<T> image) {
        ArrayLocalizableCursor<T> arrayLocalizableCursor = new ArrayLocalizableCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        return arrayLocalizableCursor;
    }

    @Override
    public ArrayLocalizablePlaneCursor<T> createLocalizablePlaneCursor(Image<T> image) {
        ArrayLocalizablePlaneCursor<T> arrayLocalizablePlaneCursor = new ArrayLocalizablePlaneCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        return arrayLocalizablePlaneCursor;
    }

    @Override
    public ArrayLocalizableByDimCursor<T> createLocalizableByDimCursor(Image<T> image) {
        ArrayLocalizableByDimCursor<T> arrayLocalizableByDimCursor = new ArrayLocalizableByDimCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        return arrayLocalizableByDimCursor;
    }

    @Override
    public ArrayLocalizableByDimOutOfBoundsCursor<T> createLocalizableByDimCursor(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        ArrayLocalizableByDimOutOfBoundsCursor<T> arrayLocalizableByDimOutOfBoundsCursor = new ArrayLocalizableByDimOutOfBoundsCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer(), outOfBoundsStrategyFactory);
        return arrayLocalizableByDimOutOfBoundsCursor;
    }

    public static int[] createAllocationSteps(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        Array.createAllocationSteps(nArray, nArray2);
        return nArray2;
    }

    public static void createAllocationSteps(int[] nArray, int[] nArray2) {
        nArray2[0] = 1;
        for (int i = 1; i < nArray.length; ++i) {
            nArray2[i] = nArray2[i - 1] * nArray[i - 1];
        }
    }

    public final int getPos(int[] nArray) {
        int n = nArray[0];
        for (int i = 1; i < this.numDimensions; ++i) {
            n += nArray[i] * this.step[i];
        }
        return n;
    }

    @Override
    public void close() {
        this.data.close();
    }

    @Override
    public boolean compareStorageContainerCompatibility(Container<?> container) {
        if (this.compareStorageContainerDimensions(container)) {
            return this.getFactory().getClass().isInstance(container.getFactory());
        }
        return false;
    }
}

