/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container;

import mpicbg.imglib.container.Container;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContainerImpl<T extends Type<T>>
implements Container<T> {
    protected final int numPixels;
    protected final int numDimensions;
    protected final long id;
    protected final int[] dim;
    final ContainerFactory factory;

    public ContainerImpl(ContainerFactory containerFactory, int[] nArray) {
        this.numDimensions = nArray.length;
        this.numPixels = ContainerImpl.getNumPixels(nArray);
        this.dim = (int[])nArray.clone();
        this.factory = containerFactory;
        this.id = Image.createUniqueId();
    }

    public static int getNumPixels(int[] nArray) {
        int n = 1;
        for (int i = 0; i < nArray.length; ++i) {
            n *= nArray[i];
        }
        return n;
    }

    @Override
    public ContainerFactory getFactory() {
        return this.factory;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public int getNumDimensions() {
        return this.dim.length;
    }

    @Override
    public int[] getDimensions() {
        return (int[])this.dim.clone();
    }

    @Override
    public void getDimensions(int[] nArray) {
        for (int i = 0; i < this.numDimensions; ++i) {
            nArray[i] = this.dim[i];
        }
    }

    @Override
    public int getDimension(int n) {
        if (n < this.numDimensions && n > -1) {
            return this.dim[n];
        }
        return 1;
    }

    @Override
    public int getNumPixels() {
        return this.numPixels;
    }

    public String toString() {
        String string = this.getClass().getCanonicalName();
        string = string.substring(string.lastIndexOf(".") + 1, string.length());
        String string2 = string + ", id '" + this.getId() + "' [" + this.dim[0];
        for (int i = 1; i < this.numDimensions; ++i) {
            string2 = string2 + "x" + this.dim[i];
        }
        string2 = string2 + "]";
        return string2;
    }

    @Override
    public boolean compareStorageContainerDimensions(Container<?> container) {
        if (container.getNumDimensions() != this.getNumDimensions()) {
            return false;
        }
        for (int i = 0; i < this.numDimensions; ++i) {
            if (this.dim[i] == container.getDimensions()[i]) continue;
            return false;
        }
        return true;
    }
}

