/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm;

import java.util.Arrays;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.numeric.RealType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ROIAlgorithm<T extends RealType<T>, S extends RealType<S>>
implements OutputAlgorithm<S>,
Benchmark {
    private final RegionOfInterestCursor<T> roiCursor;
    private final int[] patchSize;
    private final int[] originOffset;
    private final Image<T> inputImage;
    private final OutOfBoundsStrategyFactory<T> outsideFactory;
    private Image<S> outputImage;
    private ImageFactory<S> imageFactory;
    private String errorMsg;
    private String name;
    private final S typeS;
    private long pTime;

    protected ROIAlgorithm(S s, Image<T> image, int[] nArray) {
        this(s, image, nArray, null);
    }

    protected ROIAlgorithm(S s, Image<T> image, int[] nArray, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        int n = image.getNumDimensions();
        int[] nArray2 = new int[n];
        this.pTime = 0L;
        this.originOffset = new int[n];
        this.inputImage = image;
        this.patchSize = (int[])nArray.clone();
        this.outputImage = null;
        this.imageFactory = null;
        this.errorMsg = "";
        this.name = null;
        this.typeS = (RealType)s.copy();
        Arrays.fill(nArray2, 0);
        if (outOfBoundsStrategyFactory == null) {
            RealType realType = (RealType)image.createType();
            realType.setZero();
            this.outsideFactory = new OutOfBoundsStrategyValueFactory<RealType>(realType);
        } else {
            this.outsideFactory = outOfBoundsStrategyFactory;
        }
        this.roiCursor = image.createLocalizableByDimCursor(this.outsideFactory).createRegionOfInterestCursor(nArray2, nArray);
        for (int i = 0; i < n; ++i) {
            this.originOffset[i] = nArray[i] / 2;
        }
    }

    protected abstract boolean patchOperation(int[] var1, RegionOfInterestCursor<T> var2);

    public void setImageFactory(ImageFactory<S> imageFactory) {
        this.imageFactory = imageFactory;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public int[] getPatchSize() {
        return (int[])this.patchSize.clone();
    }

    protected Image<S> getOutputImage() {
        if (this.outputImage == null) {
            if (this.imageFactory == null) {
                this.imageFactory = new ImageFactory<S>(this.typeS, this.inputImage.getContainerFactory());
            }
            this.outputImage = this.name == null ? this.imageFactory.createImage(this.inputImage.getDimensions()) : this.imageFactory.createImage(this.inputImage.getDimensions(), this.name);
        }
        return this.outputImage;
    }

    @Override
    public Image<S> getResult() {
        return this.outputImage;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMsg;
    }

    protected void setErrorMessage(String string) {
        this.errorMsg = string;
    }

    protected int[] positionOffset(int[] nArray, int[] nArray2) {
        if (nArray2.length < nArray.length) {
            throw new RuntimeException("Cannot copy " + nArray.length + " values into array of length " + nArray2.length);
        }
        if (nArray.length < this.originOffset.length) {
            throw new RuntimeException("Position vector has less cardinality than the input image's dimensionality.");
        }
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i] - this.originOffset[i];
        }
        return nArray2;
    }

    @Override
    public boolean process() {
        LocalizableCursor<S> localizableCursor = this.getOutputImage().createLocalizableCursor();
        int[] nArray = new int[this.inputImage.getNumDimensions()];
        int[] nArray2 = new int[this.inputImage.getNumDimensions()];
        long l = System.currentTimeMillis();
        while (localizableCursor.hasNext()) {
            localizableCursor.fwd();
            localizableCursor.getPosition(nArray);
            this.roiCursor.reset(this.positionOffset(nArray, nArray2));
            if (this.patchOperation(nArray, this.roiCursor)) continue;
            localizableCursor.close();
            return false;
        }
        localizableCursor.close();
        this.pTime = System.currentTimeMillis() - l;
        return true;
    }

    @Override
    public boolean checkInput() {
        return this.roiCursor.isActive();
    }

    public void close() {
        this.roiCursor.close();
    }

    @Override
    public long getProcessingTime() {
        return this.pTime;
    }
}

