/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm;

import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanvasImage<T extends Type<T>>
implements OutputAlgorithm<T>,
Benchmark {
    final Image<T> input;
    final Image<T> output;
    final OutOfBoundsStrategyFactory<T> outOfBoundsFactory;
    final int numDimensions;
    final int[] newSize;
    final int[] offset;
    final int[] location;
    String errorMessage = "";
    int numThreads;
    long processingTime;

    public CanvasImage(Image<T> image, int[] nArray, int[] nArray2, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        this.input = image;
        this.outOfBoundsFactory = outOfBoundsStrategyFactory;
        this.numDimensions = image.getNumDimensions();
        this.newSize = (int[])nArray.clone();
        this.location = new int[this.numDimensions];
        this.offset = nArray2;
        this.processingTime = -1L;
        if (nArray == null || nArray.length != this.numDimensions) {
            this.errorMessage = "newSize is invalid: null or not of same dimensionality as input image";
            this.output = null;
        } else if (nArray2 == null || nArray2.length != this.numDimensions) {
            this.errorMessage = "offset is invalid: null or not of same dimensionality as input image";
            this.output = null;
        } else {
            for (int i = 0; i < this.numDimensions; ++i) {
                if (outOfBoundsStrategyFactory != null || nArray2[i] >= 0) continue;
                this.errorMessage = "no OutOfBoundsStrategyFactory given but image size should increase, that is not possible";
            }
            this.output = this.errorMessage.length() == 0 ? image.createNewImage(nArray) : null;
        }
    }

    public int[] getOffset() {
        return (int[])this.offset.clone();
    }

    public CanvasImage(Image<T> image, int[] nArray, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        this(image, nArray, CanvasImage.computeOffset(image, nArray), outOfBoundsStrategyFactory);
    }

    private static int[] computeOffset(Image<?> image, int[] nArray) {
        int[] nArray2 = new int[image.getNumDimensions()];
        for (int i = 0; i < image.getNumDimensions(); ++i) {
            nArray2[i] = (image.getDimension(i) - nArray[i]) / 2;
        }
        return nArray2;
    }

    public CanvasImage(Image<T> image, int[] nArray) {
        this(image, nArray, null);
    }

    @Override
    public boolean process() {
        long l = System.currentTimeMillis();
        LocalizableCursor<T> localizableCursor = this.output.createLocalizableCursor();
        LocalizableByDimCursor<T> localizableByDimCursor = this.outOfBoundsFactory == null ? this.input.createLocalizableByDimCursor() : this.input.createLocalizableByDimCursor(this.outOfBoundsFactory);
        while (localizableCursor.hasNext()) {
            localizableCursor.fwd();
            localizableCursor.getPosition(this.location);
            for (int i = 0; i < this.numDimensions; ++i) {
                int n = i;
                this.location[n] = this.location[n] + this.offset[i];
            }
            localizableByDimCursor.moveTo(this.location);
            localizableCursor.getType().set(localizableByDimCursor.getType());
        }
        localizableCursor.close();
        localizableByDimCursor.close();
        this.processingTime = System.currentTimeMillis() - l;
        return true;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public Image<T> getResult() {
        return this.output;
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.input == null) {
            this.errorMessage = "Input image is null";
            return false;
        }
        if (this.output == null) {
            this.errorMessage = "Output image is null, maybe not enough memory";
            return false;
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        if (this.errorMessage.length() > 0) {
            this.errorMessage = "CanvasImage(): " + this.errorMessage;
        }
        return this.errorMessage;
    }
}

