/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.tpane;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.tpane.TinyObserver;
import org.openmicroscopy.shoola.util.ui.tpane.TinyPane;

public class SizeButton
extends JButton
implements TinyObserver,
PropertyChangeListener,
ActionListener {
    static final String COLLAPSE_TOOLTIP = "Collapse";
    static final String EXPAND_TOOLTIP = "Expand";
    private TinyPane model;

    SizeButton(TinyPane model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setOpaque(false);
        this.setFocusPainted(false);
        this.setRolloverEnabled(true);
        this.model = model;
    }

    public void attach() {
        this.addActionListener(this);
        this.model.addPropertyChangeListener("collapsed", this);
        this.propertyChange(null);
    }

    public void detach() {
        this.model.removePropertyChangeListener("collapsed", this);
    }

    public void propertyChange(PropertyChangeEvent pce) {
        IconManager icons = IconManager.getInstance();
        if (this.model.isCollapsed()) {
            this.setIcon(icons.getIcon(33));
            this.setRolloverIcon(icons.getIcon(34));
            this.setToolTipText(EXPAND_TOOLTIP);
        } else {
            this.setIcon(icons.getIcon(31));
            this.setRolloverIcon(icons.getIcon(32));
            this.setToolTipText(COLLAPSE_TOOLTIP);
        }
    }

    public void actionPerformed(ActionEvent ae) {
        boolean b = !this.model.isCollapsed();
        this.model.setCollapsed(b);
    }

    public boolean isFocusable() {
        return false;
    }

    public void requestFocus() {
    }
}

