/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.tpane;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.openmicroscopy.shoola.util.ui.tpane.TinyPane;

class BorderListener
extends MouseInputAdapter
implements SwingConstants {
    private static final int RESIZE_NONE = 0;
    private boolean discardRelease;
    private int resizeCornerSize = 16;
    private static DesktopManager sharedDesktopManager;
    private boolean dragging;
    private int xAbs;
    private int yAbs;
    private int xView;
    private int yView;
    private Rectangle startingBounds;
    private Rectangle parentBounds;
    private int resizeDir;
    private TinyPane frame;

    protected DesktopManager getDesktopManager() {
        if (sharedDesktopManager == null) {
            sharedDesktopManager = new DefaultDesktopManager();
        }
        return sharedDesktopManager;
    }

    BorderListener(TinyPane frame) {
        if (frame == null) {
            throw new NullPointerException("No frame.");
        }
        this.frame = frame;
        Container parent = frame.getParent();
        if (parent != null) {
            this.parentBounds = parent.getBounds();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.discardRelease) {
            this.discardRelease = false;
            return;
        }
        this.frame.notifyEndMoving();
        if (this.resizeDir == 0) {
            this.getDesktopManager().endDraggingFrame(this.frame);
            this.dragging = false;
        } else {
            this.frame.setCursor(Cursor.getPredefinedCursor(0));
            this.getDesktopManager().endResizingFrame(this.frame);
        }
        this.xAbs = 0;
        this.yAbs = 0;
        this.xView = 0;
        this.yView = 0;
        this.startingBounds = null;
        this.resizeDir = 0;
    }

    public void mousePressed(MouseEvent e) {
        Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
        this.xView = e.getX();
        this.yView = e.getY();
        this.xAbs = p.x;
        this.yAbs = p.y;
        this.startingBounds = this.frame.getBounds();
        this.resizeDir = 0;
        Insets i = this.frame.getInsets();
        Point ep = new Point(this.xView, this.yView);
        JComponent titleBar = this.frame.getTitleBar();
        if (e.getSource() == titleBar) {
            Point np = titleBar.getLocation();
            ep.x += np.x;
            ep.y += np.y;
        }
        this.frame.onFrameIconPressed(ep);
        if (e.getSource() == titleBar && ep.x > i.left && ep.y > i.top && ep.x < this.frame.getWidth() - i.right) {
            this.getDesktopManager().beginDraggingFrame(this.frame);
            this.dragging = true;
            return;
        }
        if (!this.frame.isResizable()) {
            return;
        }
        if (e.getSource() == this.frame || e.getSource() == titleBar) {
            if (ep.x <= i.left) {
                this.resizeDir = ep.y < this.resizeCornerSize + i.top ? 8 : (ep.y > this.frame.getHeight() - this.resizeCornerSize - i.bottom ? 6 : 7);
            } else if (ep.x >= this.frame.getWidth() - i.right) {
                this.resizeDir = ep.y < this.resizeCornerSize + i.top ? 2 : (ep.y > this.frame.getHeight() - this.resizeCornerSize - i.bottom ? 4 : 3);
            } else if (ep.y <= i.top) {
                this.resizeDir = ep.x < this.resizeCornerSize + i.left ? 8 : (ep.x > this.frame.getWidth() - this.resizeCornerSize - i.right ? 2 : 1);
            } else if (ep.y >= this.frame.getHeight() - i.bottom) {
                this.resizeDir = ep.x < this.resizeCornerSize + i.left ? 6 : (ep.x > this.frame.getWidth() - this.resizeCornerSize - i.right ? 4 : 5);
            } else {
                this.discardRelease = true;
                return;
            }
            this.getDesktopManager().beginResizingFrame(this.frame, this.resizeDir);
            Cursor s = Cursor.getPredefinedCursor(0);
            switch (this.resizeDir) {
                case 5: {
                    s = Cursor.getPredefinedCursor(9);
                    break;
                }
                case 1: {
                    s = Cursor.getPredefinedCursor(8);
                    break;
                }
                case 7: {
                    s = Cursor.getPredefinedCursor(10);
                    break;
                }
                case 3: {
                    s = Cursor.getPredefinedCursor(11);
                    break;
                }
                case 4: {
                    s = Cursor.getPredefinedCursor(5);
                    break;
                }
                case 6: {
                    s = Cursor.getPredefinedCursor(4);
                    break;
                }
                case 8: {
                    s = Cursor.getPredefinedCursor(6);
                    break;
                }
                case 2: {
                    s = Cursor.getPredefinedCursor(7);
                }
            }
            this.frame.setCursor(s);
            return;
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.startingBounds == null) {
            return;
        }
        Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
        int deltaX = this.xAbs - p.x;
        int deltaY = this.yAbs - p.y;
        Dimension min = this.frame.getMinimumSize();
        Dimension max = this.frame.getMaximumSize();
        Insets i = this.frame.getInsets();
        if (this.dragging) {
            if ((e.getModifiers() & 0x10) != 16) {
                return;
            }
            Dimension s = this.frame.getParent().getSize();
            int pWidth = s.width;
            int pHeight = s.height;
            int newX = this.startingBounds.x - deltaX;
            int newY = this.startingBounds.y - deltaY;
            if (newX + i.left <= -this.xView) {
                newX = -this.xView - i.left + 1;
            }
            if (newY + i.top <= -this.yView) {
                newY = -this.yView - i.top + 1;
            }
            if (newX + this.xView + i.right >= pWidth) {
                newX = pWidth - this.xView - i.right - 1;
            }
            if (newY + this.yView + i.bottom >= pHeight) {
                newY = pHeight - this.yView - i.bottom - 1;
            }
            this.getDesktopManager().dragFrame(this.frame, newX, newY);
            return;
        }
        if (!this.frame.isResizable()) {
            return;
        }
        int newX = this.frame.getX();
        int newY = this.frame.getY();
        int newW = this.frame.getWidth();
        int newH = this.frame.getHeight();
        this.parentBounds = this.frame.getParent().getBounds();
        switch (this.resizeDir) {
            case 0: {
                this.frame.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            case 1: {
                if (this.startingBounds.height + deltaY < min.height) {
                    deltaY = min.height - this.startingBounds.height;
                } else if (this.startingBounds.height + deltaY > max.height) {
                    deltaY = max.height - this.startingBounds.height;
                }
                if (this.startingBounds.y - deltaY < 0) {
                    deltaY = this.startingBounds.y;
                }
                newX = this.startingBounds.x;
                newY = this.startingBounds.y - deltaY;
                newW = this.startingBounds.width;
                newH = this.startingBounds.height + deltaY;
                this.frame.setCursor(Cursor.getPredefinedCursor(8));
                break;
            }
            case 2: {
                if (this.startingBounds.height + deltaY < min.height) {
                    deltaY = min.height - this.startingBounds.height;
                } else if (this.startingBounds.height + deltaY > max.height) {
                    deltaY = max.height - this.startingBounds.height;
                }
                if (this.startingBounds.y - deltaY < 0) {
                    deltaY = this.startingBounds.y;
                }
                if (this.startingBounds.width - deltaX < min.width) {
                    deltaX = this.startingBounds.width - min.width;
                } else if (this.startingBounds.width - deltaX > max.width) {
                    deltaX = -(max.width - this.startingBounds.width);
                }
                if (this.startingBounds.x + this.startingBounds.width - deltaX > this.parentBounds.width) {
                    deltaX = this.startingBounds.x + this.startingBounds.width - this.parentBounds.width;
                }
                newX = this.startingBounds.x;
                newY = this.startingBounds.y - deltaY;
                newW = this.startingBounds.width - deltaX;
                newH = this.startingBounds.height + deltaY;
                this.frame.setCursor(Cursor.getPredefinedCursor(7));
                break;
            }
            case 3: {
                if (this.startingBounds.width - deltaX < min.width) {
                    deltaX = this.startingBounds.width - min.width;
                } else if (this.startingBounds.width - deltaX > max.width) {
                    deltaX = this.startingBounds.width - max.width;
                }
                if (this.startingBounds.x + this.startingBounds.width - deltaX > this.parentBounds.width) {
                    deltaX = this.startingBounds.x + this.startingBounds.width - this.parentBounds.width;
                }
                newW = this.startingBounds.width - deltaX;
                newH = this.startingBounds.height;
                this.frame.setCursor(Cursor.getPredefinedCursor(11));
                break;
            }
            case 4: {
                if (this.startingBounds.width - deltaX < min.width) {
                    deltaX = this.startingBounds.width - min.width;
                } else if (this.startingBounds.width - deltaX > max.width) {
                    deltaX = this.startingBounds.width - max.width;
                }
                if (this.startingBounds.x + this.startingBounds.width - deltaX > this.parentBounds.width) {
                    deltaX = this.startingBounds.x + this.startingBounds.width - this.parentBounds.width;
                }
                if (this.startingBounds.height - deltaY < min.height) {
                    deltaY = this.startingBounds.height - min.height;
                } else if (this.startingBounds.height - deltaY > max.height) {
                    deltaY = -(max.height - this.startingBounds.height);
                }
                if (this.startingBounds.y + this.startingBounds.height - deltaY > this.parentBounds.height) {
                    deltaY = this.startingBounds.y + this.startingBounds.height - this.parentBounds.height;
                }
                newW = this.startingBounds.width - deltaX;
                newH = this.startingBounds.height - deltaY;
                this.frame.setCursor(Cursor.getPredefinedCursor(5));
                break;
            }
            case 5: {
                if (this.startingBounds.height - deltaY < min.height) {
                    deltaY = this.startingBounds.height - min.height;
                } else if (this.startingBounds.height - deltaY > max.height) {
                    deltaY = -(max.height - this.startingBounds.height);
                }
                if (this.startingBounds.y + this.startingBounds.height - deltaY > this.parentBounds.height) {
                    deltaY = this.startingBounds.y + this.startingBounds.height - this.parentBounds.height;
                }
                newW = this.startingBounds.width;
                newH = this.startingBounds.height - deltaY;
                this.frame.setCursor(Cursor.getPredefinedCursor(9));
                break;
            }
            case 6: {
                if (this.startingBounds.height - deltaY < min.height) {
                    deltaY = this.startingBounds.height - min.height;
                } else if (this.startingBounds.height - deltaY > max.height) {
                    deltaY = -(max.height - this.startingBounds.height);
                }
                if (this.startingBounds.y + this.startingBounds.height - deltaY > this.parentBounds.height) {
                    deltaY = this.startingBounds.y + this.startingBounds.height - this.parentBounds.height;
                }
                if (this.startingBounds.width + deltaX < min.width) {
                    deltaX = -(this.startingBounds.width - min.width);
                } else if (this.startingBounds.width + deltaX > max.width) {
                    deltaX = max.width - this.startingBounds.width;
                }
                if (this.startingBounds.x - deltaX < 0) {
                    deltaX = this.startingBounds.x;
                }
                newX = this.startingBounds.x - deltaX;
                newY = this.startingBounds.y;
                newW = this.startingBounds.width + deltaX;
                newH = this.startingBounds.height - deltaY;
                this.frame.setCursor(Cursor.getPredefinedCursor(4));
                break;
            }
            case 7: {
                if (this.startingBounds.width + deltaX < min.width) {
                    deltaX = -(this.startingBounds.width - min.width);
                } else if (this.startingBounds.width + deltaX > max.width) {
                    deltaX = max.width - this.startingBounds.width;
                }
                if (this.startingBounds.x - deltaX < 0) {
                    deltaX = this.startingBounds.x;
                }
                newX = this.startingBounds.x - deltaX;
                newY = this.startingBounds.y;
                newW = this.startingBounds.width + deltaX;
                newH = this.startingBounds.height;
                this.frame.setCursor(Cursor.getPredefinedCursor(10));
                break;
            }
            case 8: {
                if (this.startingBounds.width + deltaX < min.width) {
                    deltaX = -(this.startingBounds.width - min.width);
                } else if (this.startingBounds.width + deltaX > max.width) {
                    deltaX = max.width - this.startingBounds.width;
                }
                if (this.startingBounds.x - deltaX < 0) {
                    deltaX = this.startingBounds.x;
                }
                if (this.startingBounds.height + deltaY < min.height) {
                    deltaY = -(this.startingBounds.height - min.height);
                } else if (this.startingBounds.height + deltaY > max.height) {
                    deltaY = max.height - this.startingBounds.height;
                }
                if (this.startingBounds.y - deltaY < 0) {
                    deltaY = this.startingBounds.y;
                }
                newX = this.startingBounds.x - deltaX;
                newY = this.startingBounds.y - deltaY;
                newW = this.startingBounds.width + deltaX;
                newH = this.startingBounds.height + deltaY;
                this.frame.setCursor(Cursor.getPredefinedCursor(6));
                break;
            }
            default: {
                return;
            }
        }
        this.getDesktopManager().resizeFrame(this.frame, newX, newY, newW, newH);
    }

    public void mouseMoved(MouseEvent e) {
        if (!this.frame.isResizable()) {
            return;
        }
        JComponent titleBar = this.frame.getTitleBar();
        if (e.getSource() == this.frame || e.getSource() == titleBar) {
            Point ep = new Point(e.getX(), e.getY());
            if (e.getSource() == titleBar) {
                Point np = titleBar.getLocation();
                ep.x += np.x;
                ep.y += np.y;
                this.frame.setCursor(new Cursor(5));
            }
            Insets i = this.frame.getInsets();
            if (ep.x <= i.left) {
                if (ep.y < this.resizeCornerSize + i.top) {
                    this.frame.setCursor(Cursor.getPredefinedCursor(6));
                } else if (ep.y > this.frame.getHeight() - this.resizeCornerSize - i.bottom) {
                    this.frame.setCursor(Cursor.getPredefinedCursor(4));
                } else {
                    this.frame.setCursor(Cursor.getPredefinedCursor(10));
                }
            } else if (ep.x >= this.frame.getWidth() - i.right) {
                if (e.getY() < this.resizeCornerSize + i.top) {
                    this.frame.setCursor(Cursor.getPredefinedCursor(7));
                } else if (ep.y > this.frame.getHeight() - this.resizeCornerSize - i.bottom) {
                    this.frame.setCursor(Cursor.getPredefinedCursor(5));
                } else {
                    this.frame.setCursor(Cursor.getPredefinedCursor(11));
                }
            } else if (ep.y <= i.top) {
                if (ep.x < this.resizeCornerSize + i.left) {
                    this.frame.setCursor(Cursor.getPredefinedCursor(6));
                } else if (ep.x > this.frame.getWidth() - this.resizeCornerSize - i.right) {
                    this.frame.setCursor(Cursor.getPredefinedCursor(7));
                } else {
                    this.frame.setCursor(Cursor.getPredefinedCursor(8));
                }
            } else if (ep.y >= this.frame.getHeight() - i.bottom) {
                if (ep.x < this.resizeCornerSize + i.left) {
                    this.frame.setCursor(Cursor.getPredefinedCursor(4));
                } else if (ep.x > this.frame.getWidth() - this.resizeCornerSize - i.right) {
                    this.frame.setCursor(Cursor.getPredefinedCursor(5));
                } else {
                    this.frame.setCursor(Cursor.getPredefinedCursor(9));
                }
            } else {
                this.frame.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
        }
    }

    public void mouseExited(MouseEvent e) {
        this.frame.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void mouseClicked(MouseEvent e) {
    }
}

