/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.lens;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openmicroscopy.shoola.util.ui.lens.LensComponent;

class ZoomAction
extends AbstractAction {
    static final int MAX = 11;
    static final int ZOOMx1 = 0;
    static final int ZOOMx2 = 1;
    static final int ZOOMx3 = 2;
    static final int ZOOMx4 = 3;
    static final int ZOOMx5 = 4;
    static final int ZOOMx6 = 5;
    static final int ZOOMx7 = 6;
    static final int ZOOMx8 = 7;
    static final int ZOOMx9 = 8;
    static final int ZOOMx10 = 9;
    static final int MANUAL = 10;
    private LensComponent lens;
    private int index;
    private static String[] names = new String[11];

    private void checkIndex(int i) {
        switch (i) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return;
            }
        }
        throw new IllegalArgumentException("Index not supported.");
    }

    static int factorToIndex(float i) {
        double d = Math.ceil(i);
        if ((double)i - d != 0.0) {
            return 10;
        }
        int v = (int)i;
        switch (v) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 9: {
                return 8;
            }
            case 10: {
                return 9;
            }
        }
        return 10;
    }

    ZoomAction(LensComponent lens, int zoomIndex) {
        this.lens = lens;
        this.checkIndex(zoomIndex);
        this.index = zoomIndex;
        this.putValue("Name", names[this.index]);
    }

    int getIndex() {
        return this.index;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.index != 10) {
            this.lens.setZoomFactor(this.index + 1);
        }
    }

    static {
        ZoomAction.names[0] = "100%";
        ZoomAction.names[1] = "200%";
        ZoomAction.names[2] = "300%";
        ZoomAction.names[3] = "400%";
        ZoomAction.names[4] = "500%";
        ZoomAction.names[5] = "600%";
        ZoomAction.names[6] = "700%";
        ZoomAction.names[7] = "800%";
        ZoomAction.names[8] = "900%";
        ZoomAction.names[9] = "1000%";
        ZoomAction.names[10] = "Manual";
    }
}

