/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.graphutils;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.openmicroscopy.shoola.util.ui.graphutils.ShapeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PointRenderer
extends StandardXYItemRenderer {
    public static final int SHAPESIZE = 4;
    private List<Color> colours;
    private List<Shape> itemShapes;

    private Ellipse2D.Double ellipse() {
        return new Ellipse2D.Double(-2.0, -2.0, 4.0, 4.0);
    }

    private Rectangle2D.Double rectangle() {
        return new Rectangle2D.Double(-2.0, -2.0, 4.0, 4.0);
    }

    public PointRenderer(List<Color> colours, List<Shape> shapes) {
        if (colours == null) {
            throw new IllegalArgumentException("List of colours cannot be null.");
        }
        if (shapes == null) {
            throw new IllegalArgumentException("List of shapes cannot be null.");
        }
        this.setBaseShapesVisible(true);
        this.setPlotLines(false);
        this.colours = colours;
        this.itemShapes = shapes;
    }

    public void setSeriesShape(int series, Shape shape) {
        this.itemShapes.set(series, shape);
    }

    public void setSeriesShape(int series, ShapeType shapeType) {
        switch (shapeType) {
            case ELLIPSE: {
                this.itemShapes.set(series, this.ellipse());
                break;
            }
            case RECTANGLE: {
                this.itemShapes.set(series, this.rectangle());
            }
        }
    }

    public Shape getItemShape(int series, int item) {
        return this.itemShapes.get(series);
    }

    public Paint getItemPaint(int row, int column) {
        return this.colours.get(row % this.colours.size());
    }
}

