/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.graphutils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.openmicroscopy.shoola.util.ui.graphutils.CustomBarRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarPlot {
    private static final String DEFAULTSERIES = "default";
    private CategoryAxis categoryAxis;
    private NumberAxis rangeAxis;
    private String title;
    private List<String> legends;
    private List<Color> colours;
    private List<Double> data;
    private DefaultCategoryDataset dataset;
    private CustomBarRenderer renderer;

    private void init() {
        this.legends = new ArrayList<String>();
        this.data = new ArrayList<Double>();
        this.colours = new ArrayList<Color>();
        this.dataset = new DefaultCategoryDataset();
    }

    public BarPlot() {
        this.init();
    }

    public BarPlot(String title, List<String> newLegends, List<Double> newData, List<Color> newColours) {
        if (newLegends == null || newData == null || newColours == null || newLegends.size() != newData.size() && newLegends.size() != newColours.size() || newLegends.size() == 0) {
            throw new IllegalArgumentException("Mismatch between argument length");
        }
        this.title = title;
        this.init();
        for (int i = 0; i < newLegends.size(); ++i) {
            this.addValue(newLegends.get(i), newData.get(i), newColours.get(i));
        }
        this.setDefaultAxis();
    }

    public void setDefaultAxis() {
        this.setXAxisName("X");
        this.setYAxisName("Y");
    }

    public void setXAxisName(String axisName) {
        if (axisName == null) {
            throw new IllegalArgumentException("Null parameter for Axis name.");
        }
        this.categoryAxis = new CategoryAxis(axisName);
    }

    public void setYAxisName(String axisName) {
        if (axisName == null) {
            throw new IllegalArgumentException("Null parameter for Axis name.");
        }
        this.rangeAxis = new NumberAxis(axisName);
    }

    public void setYAxisRange(double axisMinRange, double axisMaxRange) {
        this.rangeAxis.setRange(axisMinRange, axisMaxRange);
        this.rangeAxis.setAutoRange(false);
    }

    public int addValue(String legend, double newData, Color color) {
        if (legend == null || color == null) {
            throw new IllegalArgumentException("Illegal argument in addSeries.");
        }
        this.legends.add(legend);
        this.data.add(newData);
        this.colours.add(color);
        this.dataset.addValue(newData, (Comparable)((Object)DEFAULTSERIES), (Comparable)((Object)legend));
        return this.dataset.getColumnCount();
    }

    public JPanel getChart() {
        this.renderer = new CustomBarRenderer(this.colours);
        CategoryPlot plot = new CategoryPlot((CategoryDataset)this.dataset, this.categoryAxis, (ValueAxis)this.rangeAxis, (CategoryItemRenderer)this.renderer);
        JFreeChart freeChart = new JFreeChart(this.title, (Plot)plot);
        ChartPanel charts = new ChartPanel(freeChart);
        JPanel graphPanel = new JPanel();
        graphPanel.setLayout(new BorderLayout());
        graphPanel.add((Component)charts, "Center");
        return graphPanel;
    }
}

