/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.filechooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FolderChooser;

public class FolderChooserDialog
extends JDialog {
    static final String TITLE = "Download files";
    public static final String LOCATION_PROPERTY = "location";
    private static final String TEXT = "Select a directory where to download the files.";
    private JCheckBox settings;
    private FolderChooser chooser;
    private String title;
    private TitlePanel header;

    private void initComponents() {
        this.settings = new JCheckBox();
        this.settings.setText("Set the current directory as default.");
        this.settings.setSelected(true);
        this.chooser = new FolderChooser(this);
    }

    private void buildGUI() {
        boolean supportsWindowDecorations;
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(0, 0));
        p.add((Component)this.chooser, "Center");
        p.add((Component)UIUtilities.buildComponentPanel(this.settings), "South");
        IconManager im = IconManager.getInstance();
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        this.header = new TitlePanel(this.title, TEXT, im.getIcon(30));
        c.add((Component)((Object)this.header), "North");
        c.add((Component)p, "Center");
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.getRootPane().setWindowDecorationStyle(6);
        }
    }

    private void setProperties() {
        this.setTitle(this.title);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FolderChooserDialog.this.chooser.cancelSelection();
            }

            public void windowOpened(WindowEvent e) {
            }
        });
    }

    public FolderChooserDialog(JFrame owner, String title) {
        super(owner);
        if (title == null || title.length() == 0) {
            title = TITLE;
        }
        this.title = title;
        this.setProperties();
        this.initComponents();
        this.buildGUI();
        this.pack();
    }

    public FolderChooserDialog(JFrame owner) {
        this(owner, TITLE);
    }

    public void setTitle(String title) {
        if (title == null || title.length() == 0) {
            title = TITLE;
        }
        this.title = title;
        super.setTitle(title);
        this.header.setTitle(title);
    }

    void close() {
        this.setVisible(false);
        this.dispose();
    }

    void setFolderPath(String path) {
        if (path == null) {
            return;
        }
        char separator = File.separatorChar;
        boolean exist = false;
        File[] l = this.chooser.getCurrentDirectory().listFiles();
        for (int i = 0; i < l.length; ++i) {
            if (!l[i].getAbsolutePath().equals(path)) continue;
            exist = true;
            break;
        }
        if (!exist) {
            new File(path).mkdir();
        }
        this.firePropertyChange(LOCATION_PROPERTY, null, path + separator);
        if (this.settings.isSelected()) {
            UIUtilities.setDefaultFolder(path);
        }
        this.close();
    }
}

