/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.colourpicker;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourListRenderer;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourPicker;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourSlider;
import org.openmicroscopy.shoola.util.ui.colourpicker.RGBControl;

public class ColourSwatchUI
extends JPanel {
    private RGBControl control;
    private JList colourlist;
    private JScrollPane scrollpane;
    private ColourSlider alphaSlider;
    private ChangeListener alphaChangeListener;
    private JTextField alphaTextbox;
    private JLabel alphaLabel;
    private ActionListener alphaTextboxActionListener;
    private boolean active;

    private void createAlphaSlider() {
        Color s1 = this.control.getColour();
        Color s = new Color(s1.getRed(), s1.getGreen(), s1.getBlue(), 0);
        Color e1 = this.control.getColour();
        Color e = new Color(e1.getRed(), s1.getGreen(), s1.getBlue(), 255);
        this.alphaSlider = new ColourSlider(0, 255, s, e);
        this.alphaSlider.setValue((int)((double)this.control.getAlpha() * 255.0));
        this.alphaChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ColourSlider src = (ColourSlider)changeEvent.getSource();
                ColourSwatchUI.this.control.setAlpha((float)src.getValue() / 255.0f);
            }
        };
        this.alphaSlider.addChangeListener(this.alphaChangeListener);
    }

    private void createAlphaTextbox() {
        this.alphaLabel = new JLabel("Alpha");
        this.alphaTextbox = new JTextField("" + (int)(this.control.getAlpha() * 255.0f));
        this.alphaTextbox.setColumns(2);
        this.alphaTextboxActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTextField src = (JTextField)actionEvent.getSource();
                try {
                    int value = Integer.parseInt(src.getText());
                    if (value >= 0 && value <= 255) {
                        ColourSwatchUI.this.control.setAlpha((float)value / 255.0f);
                    } else {
                        ColourPicker.invalidColorValue();
                        ColourSwatchUI.this.alphaTextbox.setText("" + (int)(ColourSwatchUI.this.control.getAlpha() * 255.0f));
                    }
                }
                catch (NumberFormatException e) {
                    ColourPicker.invalidColorValue();
                    ColourSwatchUI.this.alphaTextbox.setText("" + (int)(ColourSwatchUI.this.control.getAlpha() * 255.0f));
                }
            }
        };
        this.alphaTextbox.addActionListener(this.alphaTextboxActionListener);
    }

    private void createColours() {
        this.colourlist = new JList<Object>(new Object[]{new Object[]{Color.blue, "Blue"}, new Object[]{Color.green, "Green"}, new Object[]{Color.red, "Red"}, new Object[]{Color.white, "White"}, new Object[]{Color.black, "Black"}, new Object[]{Color.gray, "Gray"}, new Object[]{Color.orange, "Orange"}, new Object[]{Color.yellow, "Yellow"}, new Object[]{new Color(75, 0, 130), "Indigo"}, new Object[]{new Color(238, 130, 238), "Violet"}});
        this.colourlist.setCellRenderer(new ColourListRenderer());
    }

    private void createUI() {
        this.createColours();
        this.createAlphaSlider();
        this.createAlphaTextbox();
        this.colourlist.setSelectionMode(0);
        this.colourlist.setLayoutOrientation(0);
        this.colourlist.setVisibleRowCount(-1);
        this.colourlist.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                Object[] obj = (Object[])ColourSwatchUI.this.colourlist.getModel().getElementAt(((JList)e.getSource()).getLeadSelectionIndex());
                ColourSwatchUI.this.control.setColour((Color)obj[0]);
            }
        });
        this.scrollpane = new JScrollPane(this.colourlist);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 80.0;
        gbc.weighty = 580.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.scrollpane, gbc);
        gbc.gridy = 1;
        gbc.weightx = 80.0;
        gbc.weighty = 5.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.alphaLabel, gbc);
        gbc.gridy = 2;
        this.add((Component)this.alphaSlider, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 20.0;
        this.add((Component)this.alphaTextbox, gbc);
    }

    ColourSwatchUI(RGBControl c) {
        if (c == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.control = c;
        this.createUI();
        this.active = false;
    }

    void setActive(boolean act) {
        this.active = act;
    }

    void refresh() {
        if (!this.active) {
            return;
        }
        this.removeListeners();
        this.updateSliders();
        this.updateTextboxes();
        this.addListeners();
        this.repaint();
    }

    void addListeners() {
        this.alphaSlider.addChangeListener(this.alphaChangeListener);
        this.alphaTextbox.addActionListener(this.alphaTextboxActionListener);
    }

    void removeListeners() {
        this.alphaSlider.removeChangeListener(this.alphaChangeListener);
        this.alphaTextbox.removeActionListener(this.alphaTextboxActionListener);
    }

    void updateAlphaSlider() {
        this.alphaSlider.setValue((int)(this.control.getAlpha() * 255.0f));
        Color s1 = this.control.getColour();
        Color s = new Color(s1.getRed(), s1.getGreen(), s1.getBlue(), 0);
        Color e = new Color(s1.getRed(), s1.getGreen(), s1.getBlue(), 255);
        this.alphaSlider.setRGBStart(s);
        this.alphaSlider.setRGBEnd(e);
    }

    void updateSliders() {
        this.updateAlphaSlider();
    }

    void updateTextboxes() {
        this.alphaTextbox.setText("" + (int)(this.control.getAlpha() * 255.0f));
    }
}

