/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.colourpicker;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourIcon;

class ColourListRenderer
extends JLabel
implements ListCellRenderer {
    private static ColourIcon icon = new ColourIcon(32, 24);
    private Border lineBorder = BorderFactory.createLineBorder(Color.gray, 1);
    private Border emptyBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);

    ColourListRenderer() {
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        Object[] array = (Object[])value;
        Color newCol = new Color(((Color)array[0]).getRed(), ((Color)array[0]).getGreen(), ((Color)array[0]).getBlue());
        icon.setColour(newCol);
        this.setIcon(icon);
        this.setVerticalAlignment(0);
        this.setIconTextGap(40);
        this.setText((String)array[1]);
        if (isSelected) {
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setForeground(list.getForeground());
            this.setBackground(list.getBackground());
        }
        if (hasFocus) {
            this.setBorder(this.lineBorder);
        } else {
            this.setBorder(this.emptyBorder);
        }
        return this;
    }
}

