/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.clsf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

class TreeCheckLabel
extends JLabel {
    private boolean selected = false;
    private boolean hasFocus = false;

    TreeCheckLabel() {
    }

    void setSelected(boolean selected) {
        this.selected = selected;
    }

    void setFocus(boolean hasFocus) {
        this.hasFocus = hasFocus;
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (d != null) {
            d = new Dimension(d.width + 3, d.height);
        }
        return d;
    }

    public void paintComponent(Graphics g) {
        Color c = UIManager.getColor("Tree.textBackground");
        if (this.selected) {
            c = UIManager.getColor("Tree.selectionBackground");
        }
        g.setColor(c);
        Dimension d = this.getPreferredSize();
        int offset = 0;
        Icon currentI = this.getIcon();
        if (currentI != null) {
            offset = currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        g.fillRect(offset, 0, d.width - offset - 1, d.height);
        if (this.hasFocus) {
            g.setColor(UIManager.getColor("Tree.selectionBorderColor"));
            g.drawRect(offset, 0, d.width - 1 - offset, d.height - 1);
        }
        super.paintComponent(g);
    }
}

