/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.border.AbstractBorder;
import org.openmicroscopy.shoola.util.image.geom.Factory;

public class ImageBorder
extends AbstractBorder {
    private Image top_center;
    private Image top_left;
    private Image top_right;
    private Image left_center;
    private Image right_center;
    private Image bottom_center;
    private Image bottom_left;
    private Image bottom_right;
    private Insets insets;

    public ImageBorder(Image top_left, Image top_center, Image top_right, Image left_center, Image right_center, Image bottom_left, Image bottom_center, Image bottom_right) {
        if (top_left == null) {
            throw new IllegalArgumentException("The top left image cannot be null.");
        }
        if (top_center == null) {
            throw new IllegalArgumentException("The top center image cannot be null.");
        }
        if (top_right == null) {
            throw new IllegalArgumentException("The top right image cannot be null.");
        }
        if (left_center == null) {
            throw new IllegalArgumentException("The left  center image cannot be null.");
        }
        if (right_center == null) {
            throw new IllegalArgumentException("The right  center image cannot be null.");
        }
        if (bottom_left == null) {
            throw new IllegalArgumentException("The bottom left image cannot be null.");
        }
        if (bottom_center == null) {
            throw new IllegalArgumentException("The bottom center image cannot be null.");
        }
        if (bottom_right == null) {
            throw new IllegalArgumentException("The bottom right image cannot be null.");
        }
        this.top_left = top_left;
        this.top_center = top_center;
        this.top_right = top_right;
        this.left_center = left_center;
        this.right_center = right_center;
        this.bottom_left = bottom_left;
        this.bottom_center = bottom_center;
        this.bottom_right = bottom_right;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public Insets getBorderInsets(Component c) {
        if (this.insets != null) {
            return this.insets;
        }
        return new Insets(this.top_center.getHeight(null), this.left_center.getWidth(null), this.bottom_center.getHeight(null), this.right_center.getWidth(null));
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        int tlw = this.top_left.getWidth(null);
        int tlh = this.top_left.getHeight(null);
        int tch = this.top_center.getHeight(null);
        int trw = this.top_right.getWidth(null);
        int trh = this.top_right.getHeight(null);
        int lcw = this.left_center.getWidth(null);
        int rcw = this.right_center.getWidth(null);
        int blw = this.bottom_left.getWidth(null);
        int blh = this.bottom_left.getHeight(null);
        int bch = this.bottom_center.getHeight(null);
        int brw = this.bottom_right.getWidth(null);
        int brh = this.bottom_right.getHeight(null);
        ImageBorder.fillTexture(g2, this.top_left, x, y, tlw, tlh);
        ImageBorder.fillTexture(g2, this.top_center, x + tlw, y, width - tlw - trw, tch);
        ImageBorder.fillTexture(g2, this.top_right, x + width - trw, y, trw, trh);
        ImageBorder.fillTexture(g2, this.left_center, x, y + tlh, lcw, height - tlh - blh);
        ImageBorder.fillTexture(g2, this.right_center, x + width - rcw, y + trh, rcw, height - trh - brh);
        ImageBorder.fillTexture(g2, this.bottom_left, x, y + height - blh, blw, blh);
        ImageBorder.fillTexture(g2, this.bottom_center, x + blw, y + height - bch, width - blw - brw, bch);
        ImageBorder.fillTexture(g2, this.bottom_right, x + width - brw, y + height - brh, brw, brh);
    }

    public static void fillTexture(Graphics2D g2, Image img, int x, int y, int w, int h) {
        BufferedImage buff = Factory.createImage(img);
        Rectangle anchor = new Rectangle(x, y, img.getWidth(null), img.getHeight(null));
        TexturePaint paint = new TexturePaint(buff, anchor);
        g2.setPaint(paint);
        g2.fillRect(x, y, w, h);
    }
}

