/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegExFactory {
    private static final List<Character> SUPPORTED_SPECIAL_CHAR = new ArrayList<Character>();

    public static boolean find(Pattern p, String input) {
        Matcher m = p.matcher(input);
        return m.find();
    }

    public static Pattern createCaseInsensitivePattern(String regEx) {
        return Pattern.compile(regEx, 2);
    }

    public static Pattern createPattern(String regEx) {
        return Pattern.compile(regEx);
    }

    public static String[] formatSearchText(List<String> terms) {
        if (terms == null) {
            return new String[0];
        }
        String[] formattedTerms = new String[terms.size()];
        Iterator<String> i = terms.iterator();
        int j = 0;
        while (i.hasNext()) {
            String value = i.next();
            if (value == null) {
                value = "";
            }
            int n = value.length();
            char[] arr = new char[n];
            String v = "";
            value.getChars(0, n, arr, 0);
            for (int k = 0; k < arr.length; ++k) {
                v = SUPPORTED_SPECIAL_CHAR.contains(Character.valueOf(arr[k])) ? v + "\\" + arr[k] : v + arr[k];
            }
            formattedTerms[j] = v;
            ++j;
        }
        return formattedTerms;
    }

    public static String formatSearchTextAsString(List<String> terms) {
        if (terms == null) {
            return "";
        }
        String[] formattedTerms = RegExFactory.formatSearchText(terms);
        String text = "";
        for (int i = 0; i < formattedTerms.length; ++i) {
            text = text + formattedTerms[i];
        }
        return text;
    }

    static {
        SUPPORTED_SPECIAL_CHAR.add(new Character('-'));
        SUPPORTED_SPECIAL_CHAR.add(new Character('['));
        SUPPORTED_SPECIAL_CHAR.add(new Character(']'));
        SUPPORTED_SPECIAL_CHAR.add(new Character('?'));
        SUPPORTED_SPECIAL_CHAR.add(new Character('+'));
        SUPPORTED_SPECIAL_CHAR.add(new Character('*'));
        SUPPORTED_SPECIAL_CHAR.add(new Character('.'));
    }
}

