/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.openmicroscopy.shoola.util.ui.GridModel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class PlateGrid
extends JTable {
    public static final int ASCENDING_LETTER = 0;
    public static final int ASCENDING_NUMBER = 1;
    public static final int MAX_ROWS = 16;
    public static final int MAX_COLUMNS = 24;
    public static final String WELL_FIELDS_PROPERTY = "wellFields";
    public static final Color BACKGROUND_COLOR = Color.WHITE;
    public static final Color GRID_COLOR = new Color(180, 213, 255);
    public static final Color SELECTED_COLOR = new Color(255, 206, 206);
    public static final Color FOCUS_COLOR = new Color(255, 135, 135);
    private static final Dimension CELL_SIZE = new Dimension(10, 10);
    private int typeRow;
    private int typeColumn;
    private boolean[][] validValues;
    private int selectedRow;
    private int selectedColumn;

    private void initialize(int rows, int columns) {
        this.selectedColumn = -1;
        this.selectedRow = -1;
        this.setTableHeader(null);
        this.setModel(new GridModel(rows, columns));
        int width = PlateGrid.CELL_SIZE.width;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn col = this.getColumnModel().getColumn(i);
            col.setMinWidth(width);
            col.setMaxWidth(width);
            col.setPreferredWidth(width);
            col.setResizable(false);
        }
        this.setRowHeight(PlateGrid.CELL_SIZE.height);
        this.setDefaultRenderer(Object.class, new GridRenderer(this));
        this.setAutoResizeMode(0);
        this.setGridColor(GRID_COLOR);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int column;
                int row = PlateGrid.this.getSelectedRow();
                if (PlateGrid.this.isCellValid(row, column = PlateGrid.this.getSelectedColumn())) {
                    Point p = new Point(row, column);
                    PlateGrid.this.selectedColumn = column;
                    PlateGrid.this.selectedRow = row;
                    PlateGrid.this.firePropertyChange(PlateGrid.WELL_FIELDS_PROPERTY, null, p);
                }
            }
        });
    }

    public PlateGrid(int typeRow, int typeColumn, boolean[][] validValues) {
        this.typeColumn = typeColumn;
        this.typeRow = typeRow;
        this.validValues = validValues;
        this.initialize(16, 24);
    }

    public PlateGrid(int columns) {
        this.validValues = new boolean[1][columns];
        for (int i = 0; i < columns; ++i) {
            this.validValues[0][i] = true;
        }
        this.initialize(1, columns);
    }

    public void selectCell(int row, int column) {
        if (!this.isCellValid(row, column)) {
            return;
        }
        this.setColumnSelectionInterval(column, column);
        this.setRowSelectionInterval(row, row);
        this.selectedRow = row;
        this.selectedColumn = column;
        this.repaint();
    }

    boolean isCellValid(int row, int column) {
        if (this.validValues == null) {
            return false;
        }
        return this.validValues[row][column];
    }

    boolean isCellDisplayed(int row, int column) {
        return this.selectedColumn == column && this.selectedRow == row;
    }

    String getCellToolTip(int row, int column) {
        String r = "";
        String c = "";
        r = this.typeRow == 0 ? UIUtilities.LETTERS.get(row) : "" + ++row;
        c = this.typeColumn == 0 ? UIUtilities.LETTERS.get(row) : "" + ++column;
        return r + "-" + c;
    }

    class GridRenderer
    extends DefaultTableCellRenderer {
        private PlateGrid model;

        GridRenderer(PlateGrid model) {
            this.model = model;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setToolTipText(this.model.getCellToolTip(row, column));
            if (this.model.isCellValid(row, column)) {
                if (this.model.isCellDisplayed(row, column)) {
                    this.setBackground(FOCUS_COLOR);
                } else {
                    this.setBackground(SELECTED_COLOR);
                }
            } else {
                this.setBackground(BACKGROUND_COLOR);
            }
            return this;
        }
    }
}

