/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class PaintPot
extends JPanel {
    protected Color colour;
    protected int w;
    protected int h;
    protected Rectangle2D strokeRect;
    protected Rectangle2D whiteRect;
    protected Polygon topPoly;
    protected Polygon bottomPoly;
    protected int[] topXPoints;
    protected int[] bottomXPoints;
    protected int[] topYPoints;
    protected int[] bottomYPoints;

    protected void createUI() {
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.topXPoints = new int[3];
        this.topYPoints = new int[3];
        this.bottomXPoints = new int[3];
        this.bottomYPoints = new int[3];
        this.strokeRect = new Rectangle2D.Double(0.0, 0.0, this.w - 1, this.h - 1);
        this.whiteRect = new Rectangle2D.Double(1.0, 1.0, this.w - 2, this.h - 2);
        double x = this.whiteRect.getX();
        double y = this.whiteRect.getY();
        this.topXPoints[0] = (int)x;
        this.topXPoints[1] = (int)(x + this.whiteRect.getWidth());
        this.topXPoints[2] = (int)x;
        this.topYPoints[0] = (int)y;
        this.topYPoints[1] = (int)y;
        this.topYPoints[2] = (int)(y + this.whiteRect.getHeight());
        this.topPoly = new Polygon(this.topXPoints, this.topYPoints, 3);
        x = this.strokeRect.getX();
        y = this.strokeRect.getY();
        this.bottomXPoints[0] = (int)x;
        this.bottomXPoints[1] = (int)(x + this.strokeRect.getWidth());
        this.bottomXPoints[2] = (int)(x + this.strokeRect.getWidth());
        this.bottomYPoints[0] = (int)(y + this.strokeRect.getHeight());
        this.bottomYPoints[1] = (int)y;
        this.bottomYPoints[2] = (int)(y + this.strokeRect.getHeight());
        this.bottomPoly = new Polygon(this.bottomXPoints, this.bottomYPoints, 3);
    }

    protected void render(Graphics og) {
        Graphics2D g = (Graphics2D)og;
        this.createUI();
        Color c = new Color(this.colour.getRed(), this.colour.getGreen(), this.colour.getBlue());
        g.setColor(c);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.fill(this.topPoly);
        g.setColor(this.colour);
        g.fill(this.bottomPoly);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setColor(Color.black);
        g.draw(this.strokeRect);
    }

    public PaintPot(Color c) {
        if (c == null) {
            throw new IllegalArgumentException("No color specified.");
        }
        this.colour = c;
        this.createUI();
    }

    public void setColour(Color col) {
        if (col == null) {
            throw new IllegalArgumentException("No color specified.");
        }
        this.colour = col;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.render(g);
    }
}

