/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import org.openmicroscopy.shoola.util.ui.ColouredButtonUI;

public class ColouredButton
extends JButton {
    private ColouredButtonUI colourButtonUI;
    private Color color;
    private boolean greyedOut;

    private void setButtonColour(Color color) {
        this.colourButtonUI.setColor(color);
    }

    public ColouredButton(String text, Color color) {
        if (color == null) {
            throw new IllegalArgumentException("No color.");
        }
        this.setModel(new DefaultButtonModel());
        this.init(text, null);
        this.colourButtonUI = new ColouredButtonUI(this, color);
        this.setUI(this.colourButtonUI);
        this.setRolloverEnabled(false);
        this.setBorder(BorderFactory.createBevelBorder(3));
        this.setBorderPainted(true);
        this.color = color;
        this.greyedOut = false;
        this.setButtonColour(color);
    }

    public void setSize(Dimension d) {
        super.setSize(d);
        this.setColor(this.color);
    }

    public void setGrayedOut(boolean greyedOut) {
        this.greyedOut = greyedOut;
        if (greyedOut) {
            this.setButtonColour(Color.LIGHT_GRAY);
        } else {
            this.setButtonColour(this.color);
        }
        this.repaint();
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.color = color;
        this.setGrayedOut(this.greyedOut);
        this.repaint();
    }

    public Color getColor() {
        return this.color;
    }

    public void setFontIndex(int index) {
        this.getFont().deriveFont(index);
    }

    public void setBackground(Color c) {
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setSize(int x, int y) {
        super.setSize(x, y);
        this.setColor(this.color);
    }

    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(preferredSize);
        this.setColor(this.color);
    }
}

