/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.util.ui.ClosableTabbedPaneComponent;
import org.openmicroscopy.shoola.util.ui.ClosableTabbedPaneUI;

public class ClosableTabbedPane
extends JTabbedPane
implements ChangeListener {
    public static final String CLOSE_TAB_PROPERTY = "closeTab";

    public ClosableTabbedPane() {
        this(1, 0);
    }

    public ClosableTabbedPane(int tabPlacement) {
        this(tabPlacement, 0);
    }

    public ClosableTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
        ClosableTabbedPaneUI ui = new ClosableTabbedPaneUI();
        this.setUI(ui);
        this.setFocusable(false);
        this.addMouseMotionListener(ui);
        this.addChangeListener(this);
    }

    void removeOthers() {
        int tabCount = this.getTabCount();
        int index = this.getSelectedIndex();
        while (tabCount-- > 0) {
            if (index == tabCount) continue;
            this.removeTabAt(tabCount);
        }
    }

    public void insertClosableComponent(ClosableTabbedPaneComponent component) {
        if (component == null) {
            return;
        }
        this.insertTab(component.getName(), component.getIcon(), component, component.getDescription(), component.getIndex());
        this.setSelectedComponent(component);
    }

    public void removeAll() {
        this.setSelectedIndex(-1);
        int tabCount = this.getTabCount();
        while (tabCount-- > 0) {
            this.removeTabAt(tabCount);
        }
    }

    public void remove(int index) {
        this.removeTabAt(index);
    }

    public void removeTabAt(int index) {
        Component c = this.getComponentAt(index);
        if (c instanceof ClosableTabbedPaneComponent) {
            int v = ((ClosableTabbedPaneComponent)c).getIndex();
            this.firePropertyChange(CLOSE_TAB_PROPERTY, -1, v);
        }
        super.removeTabAt(index);
        ((ClosableTabbedPaneUI)this.ui).resetDefault();
        int n = this.getTabCount();
        if (n == 0) {
            return;
        }
        if (index > n) {
            this.setSelectedComponent(this.getComponentAt(n - 1));
        }
    }

    public void addTab(String title, Icon icon, Component component) {
        this.insertTab(title, icon, component, "", this.getTabCount());
    }

    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        int addIndex = this.indexOfComponent(component);
        if (addIndex != -1) {
            this.setSelectedComponent(component);
            return;
        }
        super.insertTab(title, icon, component, tip, this.getTabCount());
        ((ClosableTabbedPaneUI)this.ui).resetDefault();
    }

    public void setSelectedComponent(Component component) {
        super.setSelectedComponent(component);
        if (component != null) {
            component.requestFocus();
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.setOpaque(true);
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (this.getSelectedIndex() == i) continue;
            this.setBackgroundAt(i, this.getBackground());
        }
    }
}

