/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Image;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.NotificationDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class BrowserLauncher {
    private static final String[] BROWSERS_UNIX = new String[6];
    private Icon topLeftIcon;

    public BrowserLauncher() {
        this(null);
    }

    public BrowserLauncher(Icon topLeftIcon) {
        this.topLeftIcon = topLeftIcon;
        if (this.topLeftIcon == null) {
            this.topLeftIcon = IconManager.getInstance().getIcon(18);
        }
    }

    public void openURL(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.contains("Mac")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.contains("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String browser = null;
                for (int count = 0; count < BROWSERS_UNIX.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", BROWSERS_UNIX[count]}).waitFor() != 0) continue;
                    browser = BROWSERS_UNIX[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            JFrame f = new JFrame();
            if (this.topLeftIcon != null) {
                f.setIconImage((Image)((Object)this.topLeftIcon));
            }
            NotificationDialog dialog = new NotificationDialog(new JFrame(), "Launch Browser", "Cannot launch The web browser.", IconManager.getInstance().getIcon(29));
            dialog.pack();
            UIUtilities.centerAndShow(dialog);
        }
    }

    static {
        BrowserLauncher.BROWSERS_UNIX[0] = "firefox";
        BrowserLauncher.BROWSERS_UNIX[1] = "opera";
        BrowserLauncher.BROWSERS_UNIX[2] = "konqueror";
        BrowserLauncher.BROWSERS_UNIX[3] = "epiphany";
        BrowserLauncher.BROWSERS_UNIX[4] = "mozilla";
        BrowserLauncher.BROWSERS_UNIX[5] = "netscape";
    }
}

