/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.model;

import java.util.ArrayList;
import java.util.TreeMap;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.exception.ROICreationException;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROICoordMap;
import org.openmicroscopy.shoola.util.roi.model.ROIIDMap;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.ShapeList;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROIMap {
    ROICoordMap roiCoordMap = new ROICoordMap();
    ROIIDMap roiIDMap = new ROIIDMap();

    public boolean containsROI(long id) {
        return this.roiIDMap.containsKey(id);
    }

    public void add(Long id, ROI roi) {
        this.roiIDMap.add(id, roi);
        this.roiCoordMap.add(roi);
    }

    public TreeMap<Long, ROI> getROIMap() {
        return this.roiIDMap.getROIMap();
    }

    public ROI getROI(long id) throws NoSuchROIException {
        return this.roiIDMap.getROI(id);
    }

    public ROIShape getShape(long id, Coord3D coord) throws NoSuchROIException {
        return this.roiIDMap.getShape(id, coord);
    }

    public ShapeList getShapeList(Coord3D coord) throws NoSuchROIException {
        return this.roiCoordMap.getShapeList(coord);
    }

    public void deleteROI(long id) throws NoSuchROIException {
        ROI roi = this.roiIDMap.getROI(id);
        this.roiCoordMap.deleteROI(roi);
        this.roiIDMap.deleteROI(id);
    }

    public void deleteShape(long id, Coord3D coord) throws NoSuchROIException {
        this.roiCoordMap.deleteShape(id, coord);
        this.roiIDMap.deleteShape(id, coord);
    }

    public void addShape(long id, Coord3D coord, ROIShape shape) throws ROICreationException, NoSuchROIException {
        this.roiIDMap.addShape(id, coord, shape);
        this.roiCoordMap.addShape(id, coord, shape);
    }

    public ArrayList<ROIShape> propagateShape(long id, Coord3D selectedShape, Coord3D start, Coord3D end) throws ROICreationException, NoSuchROIException {
        ArrayList<ROIShape> addedList = new ArrayList<ROIShape>();
        if (!this.roiIDMap.containsKey(id)) {
            throw new NoSuchROIException("No ROI with id : " + id);
        }
        ROI roi = this.roiIDMap.getROI(id);
        int mint = Math.min(start.getTimePoint(), end.getTimePoint());
        int maxt = Math.max(start.getTimePoint(), end.getTimePoint());
        int minz = Math.min(start.getZSection(), end.getZSection());
        int maxz = Math.max(start.getZSection(), end.getZSection());
        ++maxt;
        ++maxz;
        ROIShape shape = roi.getShape(selectedShape);
        for (int t = mint; t < maxt; ++t) {
            for (int z = minz; z < maxz; ++z) {
                Coord3D newCoord = new Coord3D(z, t);
                if (selectedShape.equals(newCoord) || roi.containsKey(newCoord)) continue;
                ROIShape newShape = new ROIShape(roi, newCoord, shape);
                newShape.getFigure().setClientObject(true);
                newShape.getFigure().setObjectDirty(true);
                this.addShape(id, newCoord, newShape);
                addedList.add(newShape);
            }
        }
        return addedList;
    }

    public void deleteShape(long id, Coord3D start, Coord3D end) throws NoSuchROIException {
        if (!this.roiIDMap.containsKey(id)) {
            throw new NoSuchROIException("No ROI with id : " + id);
        }
        ROI roi = this.roiIDMap.getROI(id);
        int mint = Math.min(start.getTimePoint(), end.getTimePoint());
        int maxt = Math.max(start.getTimePoint(), end.getTimePoint());
        int minz = Math.min(start.getZSection(), end.getZSection());
        int maxz = Math.max(start.getZSection(), end.getZSection());
        ++maxt;
        ++maxz;
        for (int t = mint; t < maxt; ++t) {
            for (int z = minz; z < maxz; ++z) {
                Coord3D newCoord = new Coord3D(z, t);
                if (!roi.containsKey(newCoord)) continue;
                this.deleteShape(id, newCoord);
            }
        }
    }
}

