/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.io;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.BezierPath;
import org.openmicroscopy.shoola.util.roi.ROIComponent;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.exception.ROICreationException;
import org.openmicroscopy.shoola.util.roi.figures.MeasureBezierFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureEllipseFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureMaskFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasurePointFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureRectangleFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.io.IOConstants;
import org.openmicroscopy.shoola.util.roi.io.util.SVGTransform;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import pojos.EllipseData;
import pojos.LineData;
import pojos.MaskData;
import pojos.PointData;
import pojos.PolygonData;
import pojos.PolylineData;
import pojos.ROIData;
import pojos.RectangleData;
import pojos.ShapeData;
import pojos.ShapeSettingsData;
import pojos.TextData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InputServerStrategy {
    public static final AttributeKey<AffineTransform> TRANSFORM = new AttributeKey("transform", null, true);
    private static final Map<AttributeKey, Object> DEFAULT_ATTRIBUTES = new HashMap<AttributeKey, Object>();
    private List<ROI> roiList = new ArrayList<ROI>();
    private ROIComponent component;

    private void addMissingAttributes(ROIFigure figure) {
        Map attributes = figure.getAttributes();
        for (AttributeKey key : DEFAULT_ATTRIBUTES.keySet()) {
            if (attributes.containsKey(key)) continue;
            key.set((Figure)figure, DEFAULT_ATTRIBUTES.get(key));
        }
    }

    private ROI createROI(ROIData roi, boolean readOnly) throws NoSuchROIException, ROICreationException {
        long id = roi.getId();
        ROI newROI = this.component.createROI(id, readOnly);
        Iterator i = roi.getIterator();
        while (i.hasNext()) {
            List list = (List)i.next();
            for (ShapeData shapeData : list) {
                ROIShape shape = this.createROIShape(shapeData, newROI, readOnly);
                if (shape == null) continue;
                shape.getFigure().setMeasurementUnits(this.component.getMeasurementUnits());
                this.component.addShape(newROI.getID(), shape.getCoord3D(), shape);
            }
        }
        return newROI;
    }

    private ROIShape createROIShape(ShapeData data, ROI roi, boolean readOnly) {
        int z = data.getZ();
        int t = data.getT();
        if (z < 0 || t < 0) {
            return null;
        }
        Coord3D coord = new Coord3D(z, t);
        ROIFigure fig = this.createROIFigure(data, readOnly);
        this.addMissingAttributes(fig);
        ROIShape shape = new ROIShape(roi, coord, fig, fig.getBounds());
        shape.setROIShapeID(data.getId());
        return shape;
    }

    private ROIFigure createROIFigure(ShapeData shape, boolean readOnly) {
        ROIFigure fig = this.createROIFigure(shape);
        fig.setReadOnly(readOnly);
        return fig;
    }

    private ROIFigure createROIFigure(ShapeData shape) {
        if (shape instanceof RectangleData) {
            return this.createRectangleFigure((RectangleData)shape);
        }
        if (shape instanceof EllipseData) {
            return this.createEllipseFigure((EllipseData)shape);
        }
        if (shape instanceof LineData) {
            return this.createLineFigure((LineData)shape);
        }
        if (shape instanceof PointData) {
            return this.createPointFigure((PointData)shape);
        }
        if (shape instanceof PolylineData) {
            return this.createPolyOrlineFigure((PolylineData)shape);
        }
        if (shape instanceof PolygonData) {
            return this.createPolygonFigure((PolygonData)shape);
        }
        if (shape instanceof MaskData) {
            return this.createMaskFigure((MaskData)shape);
        }
        if (shape instanceof TextData) {
            return this.createTextFigure((TextData)shape);
        }
        return null;
    }

    private MeasureEllipseFigure createEllipseFigure(EllipseData data) {
        double cx = data.getX();
        double cy = data.getY();
        double rx = data.getRadiusX();
        double ry = data.getRadiusY();
        double x = cx - rx;
        double y = cy - ry;
        double width = rx * 2.0;
        double height = ry * 2.0;
        MeasureEllipseFigure fig = new MeasureEllipseFigure(data.isReadOnly(), data.isClientObject());
        fig.setEllipse(x, y, width, height);
        this.addShapeSettings(fig, data.getShapeSettings());
        fig.setText(data.getText());
        try {
            AffineTransform transform = SVGTransform.toTransform(data.getTransform());
            TRANSFORM.set((Figure)fig, (Object)transform);
        }
        catch (IOException e) {
            // empty catch block
        }
        return fig;
    }

    private MeasurePointFigure createPointFigure(PointData data) {
        double r = 5.0;
        double x = data.getX() - r;
        double y = data.getY() - r;
        MeasurePointFigure fig = new MeasurePointFigure(data.getText(), x, y, 2.0 * r, 2.0 * r, data.isReadOnly(), data.isClientObject());
        this.addShapeSettings(fig, data.getShapeSettings());
        try {
            AffineTransform transform = SVGTransform.toTransform(data.getTransform());
            TRANSFORM.set((Figure)fig, (Object)transform);
        }
        catch (IOException e) {
            // empty catch block
        }
        return fig;
    }

    private MeasureTextFigure createTextFigure(TextData data) {
        double x = data.getX();
        double y = data.getY();
        MeasureTextFigure fig = new MeasureTextFigure(x, y, data.isReadOnly(), data.isClientObject());
        fig.setText(data.getText());
        this.addShapeSettings(fig, data.getShapeSettings());
        try {
            AffineTransform transform = SVGTransform.toTransform(data.getTransform());
            TRANSFORM.set((Figure)fig, (Object)transform);
        }
        catch (IOException e) {
            // empty catch block
        }
        return fig;
    }

    private MeasureRectangleFigure createRectangleFigure(RectangleData data) {
        double x = data.getX();
        double y = data.getY();
        double width = data.getWidth();
        double height = data.getHeight();
        MeasureRectangleFigure fig = new MeasureRectangleFigure(x, y, width, height, data.isReadOnly(), data.isClientObject());
        this.addShapeSettings(fig, data.getShapeSettings());
        fig.setText(data.getText());
        try {
            AffineTransform transform = SVGTransform.toTransform(data.getTransform());
            TRANSFORM.set((Figure)fig, (Object)transform);
        }
        catch (IOException e) {
            // empty catch block
        }
        return fig;
    }

    private MeasureMaskFigure createMaskFigure(MaskData data) {
        double x = data.getX();
        double y = data.getY();
        double width = data.getWidth();
        double height = data.getHeight();
        BufferedImage mask = data.getMask();
        MeasureMaskFigure fig = new MeasureMaskFigure(x, y, width, height, mask, data.isReadOnly(), data.isClientObject());
        fig.setVisible(true);
        this.addShapeSettings(fig, data.getShapeSettings());
        fig.setText(data.getText());
        try {
            AffineTransform transform = SVGTransform.toTransform(data.getTransform());
            TRANSFORM.set((Figure)fig, (Object)transform);
        }
        catch (IOException e) {
            // empty catch block
        }
        return fig;
    }

    private MeasureLineFigure createLineFigure(LineData data) {
        double x1 = data.getX1();
        double y1 = data.getY1();
        double x2 = data.getX2();
        double y2 = data.getY2();
        MeasureLineFigure fig = new MeasureLineFigure(data.isReadOnly(), data.isClientObject());
        fig.removeAllNodes();
        fig.addNode(new BezierPath.Node(new Double(x1).doubleValue(), new Double(y1).doubleValue()));
        fig.addNode(new BezierPath.Node(new Double(x2).doubleValue(), new Double(y2).doubleValue()));
        this.addShapeSettings(fig, data.getShapeSettings());
        fig.setText(data.getText());
        try {
            AffineTransform transform = SVGTransform.toTransform(data.getTransform());
            TRANSFORM.set((Figure)fig, (Object)transform);
        }
        catch (IOException e) {
            // empty catch block
        }
        return fig;
    }

    private MeasureBezierFigure createPolygonFigure(PolygonData data) {
        MeasureBezierFigure fig = new MeasureBezierFigure(false, data.isReadOnly(), data.isClientObject());
        List points = data.getPoints();
        List points1 = data.getPoints1();
        List points2 = data.getPoints2();
        List mask = data.getMaskPoints();
        for (int i = 0; i < points.size(); ++i) {
            BezierPath.Node newNode = new BezierPath.Node(((Integer)mask.get(i)).intValue(), (Point2D.Double)points.get(i), (Point2D.Double)points1.get(i), (Point2D.Double)points2.get(i));
            fig.addNode(newNode);
        }
        this.addShapeSettings(fig, data.getShapeSettings());
        fig.setText(data.getText());
        try {
            AffineTransform transform = SVGTransform.toTransform(data.getTransform());
            TRANSFORM.set((Figure)fig, (Object)transform);
        }
        catch (IOException e) {
            // empty catch block
        }
        fig.setClosed(true);
        return fig;
    }

    private ROIFigure createPolyOrlineFigure(PolylineData data) {
        List mask = data.getMaskPoints();
        boolean line = true;
        for (int i = 0; i < mask.size(); ++i) {
            if ((Integer)mask.get(i) == 0) continue;
            line = false;
        }
        if (line) {
            return this.createLineFromPolylineFigure(data);
        }
        return this.createPolylineFromPolylineFigure(data);
    }

    private ROIFigure createLineFromPolylineFigure(PolylineData data) {
        List points = data.getPoints();
        MeasureLineFigure fig = new MeasureLineFigure(data.isReadOnly(), data.isClientObject());
        fig.removeAllNodes();
        for (int i = 0; i < points.size(); ++i) {
            BezierPath.Node newNode = new BezierPath.Node((Point2D.Double)points.get(i));
            fig.addNode(newNode);
        }
        this.addShapeSettings(fig, data.getShapeSettings());
        fig.setText(data.getText());
        try {
            AffineTransform transform = SVGTransform.toTransform(data.getTransform());
            TRANSFORM.set((Figure)fig, (Object)transform);
        }
        catch (IOException e) {
            // empty catch block
        }
        return fig;
    }

    private ROIFigure createPolylineFromPolylineFigure(PolylineData data) {
        List points = data.getPoints();
        List points1 = data.getPoints1();
        List points2 = data.getPoints2();
        List mask = data.getMaskPoints();
        MeasureBezierFigure fig = new MeasureBezierFigure(false, data.isReadOnly(), data.isClientObject());
        for (int i = 0; i < points.size(); ++i) {
            BezierPath.Node newNode = new BezierPath.Node(((Integer)mask.get(i)).intValue(), (Point2D.Double)points.get(i), (Point2D.Double)points1.get(i), (Point2D.Double)points2.get(i));
            fig.addNode(newNode);
        }
        this.addShapeSettings(fig, data.getShapeSettings());
        fig.setText(data.getText());
        try {
            AffineTransform transform = SVGTransform.toTransform(data.getTransform());
            TRANSFORM.set((Figure)fig, (Object)transform);
        }
        catch (IOException e) {
            // empty catch block
        }
        return fig;
    }

    private void addShapeSettings(ROIFigure figure, ShapeSettingsData data) {
        AttributeKeys.STROKE_WIDTH.set((Figure)figure, (Object)data.getStrokeWidth());
        AttributeKeys.STROKE_COLOR.set((Figure)figure, (Object)data.getStrokeColor());
        AttributeKeys.FILL_COLOR.set((Figure)figure, (Object)data.getFillColor());
        AttributeKeys.FONT_FACE.set((Figure)figure, (Object)data.getFont());
        AttributeKeys.FONT_SIZE.set((Figure)figure, (Object)new Double(data.getFontSize()));
        AttributeKeys.FONT_ITALIC.set((Figure)figure, (Object)data.isFontItalic());
        AttributeKeys.FONT_BOLD.set((Figure)figure, (Object)data.isFontBold());
        AttributeKeys.STROKE_CAP.set((Figure)figure, (Object)data.getLineCap());
    }

    InputServerStrategy() {
    }

    List<ROI> readROI(Collection rois, ROIComponent component, boolean readOnly) throws ROICreationException, NoSuchROIException {
        if (component == null) {
            throw new IllegalArgumentException("No component.");
        }
        this.component = component;
        for (Object o : rois) {
            if (!(o instanceof ROIData)) continue;
            this.roiList.add(this.createROI((ROIData)o, readOnly));
        }
        return this.roiList;
    }

    static {
        DEFAULT_ATTRIBUTES.put(MeasurementAttributes.FILL_COLOR, ShapeSettingsData.DEFAULT_FILL_COLOUR);
        DEFAULT_ATTRIBUTES.put(MeasurementAttributes.STROKE_COLOR, ShapeSettingsData.DEFAULT_STROKE_COLOUR);
        DEFAULT_ATTRIBUTES.put(MeasurementAttributes.TEXT_COLOR, IOConstants.DEFAULT_TEXT_COLOUR);
        DEFAULT_ATTRIBUTES.put(MeasurementAttributes.FONT_SIZE, 12);
        DEFAULT_ATTRIBUTES.put(MeasurementAttributes.FONT_BOLD, "normal");
        DEFAULT_ATTRIBUTES.put(MeasurementAttributes.STROKE_WIDTH, 1.0);
        DEFAULT_ATTRIBUTES.put(MeasurementAttributes.TEXT, "Text");
        DEFAULT_ATTRIBUTES.put(MeasurementAttributes.MEASUREMENTTEXT_COLOUR, IOConstants.DEFAULT_MEASUREMENT_TEXT_COLOUR);
        DEFAULT_ATTRIBUTES.put(MeasurementAttributes.SHOWMEASUREMENT, false);
        DEFAULT_ATTRIBUTES.put(MeasurementAttributes.SHOWTEXT, false);
    }
}

