/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.figures;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.jhotdraw.draw.FigureListener;
import org.openmicroscopy.shoola.util.roi.figures.MeasureRectangleFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasureMaskFigure
extends MeasureRectangleFigure
implements ROIFigure {
    protected BufferedImage mask;

    public MeasureMaskFigure() {
        this("Text", 0.0, 0.0, 0.0, 0.0, null, false, true);
    }

    public MeasureMaskFigure(String text) {
        this(text, 0.0, 0.0, 0.0, 0.0, null, false, true);
    }

    public MeasureMaskFigure(double x, double y, double width, double height, BufferedImage mask) {
        this("Text", x, y, width, height, mask, false, true);
    }

    public MeasureMaskFigure(double x, double y, double width, double height, BufferedImage mask, boolean readOnly, boolean clientObject) {
        this("Text", x, y, width, height, mask, readOnly, clientObject);
    }

    public MeasureMaskFigure(String text, double x, double y, double width, double height, BufferedImage mask, boolean readOnly, boolean clientObject) {
        super(text, x, y, width, height, readOnly, clientObject);
        this.mask = mask;
    }

    public void setMask(BufferedImage mask) {
        this.mask = mask;
    }

    public BufferedImage getMask() {
        return this.mask;
    }

    @Override
    public void draw(Graphics2D g) {
        g.drawImage(this.mask, (int)this.getX(), (int)this.getY(), (int)this.getWidth(), (int)this.getHeight(), null);
    }

    private boolean hasColour(int rgb) {
        Color toColor = new Color(rgb);
        return toColor.getAlpha() != 0;
    }

    @Override
    public List<Point> getPoints() {
        Rectangle r = this.rectangle.getBounds();
        ArrayList<Point> vector = new ArrayList<Point>(r.height * r.width);
        int xEnd = r.x + r.width;
        int yEnd = r.y + r.height;
        for (int y = r.y; y < yEnd; ++y) {
            for (int x = r.x; x < xEnd; ++x) {
                if (!this.hasColour(this.mask.getRGB(x, y))) continue;
                vector.add(new Point(x, y));
            }
        }
        return vector;
    }

    @Override
    public MeasureMaskFigure clone() {
        MeasureMaskFigure that = (MeasureMaskFigure)super.clone();
        that.setReadOnly(this.isReadOnly());
        that.setClientObject(this.isClientObject());
        that.setObjectDirty(true);
        that.setMask(this.getMask());
        return that;
    }

    @Override
    public List<FigureListener> getFigureListeners() {
        Object[] listeners;
        ArrayList<FigureListener> figListeners = new ArrayList<FigureListener>();
        for (Object listener : listeners = this.listenerList.getListenerList()) {
            if (!(listener instanceof FigureListener)) continue;
            figListeners.add((FigureListener)listener);
        }
        return figListeners;
    }
}

