/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.mem;

import org.openmicroscopy.shoola.util.mem.Copiable;

public abstract class CopiableArray
implements Copiable {
    private Copiable[] elements;

    protected CopiableArray(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size cannot be <=0");
        }
        this.elements = new Copiable[size];
    }

    protected abstract CopiableArray makeNew(int var1);

    public int getSize() {
        return this.elements.length;
    }

    public void set(Copiable element, int index) {
        if (index >= this.elements.length || index < 0) {
            throw new IllegalArgumentException("index not valid");
        }
        this.elements[index] = element;
    }

    public Copiable get(int index) {
        if (index >= this.elements.length || index < 0) {
            throw new IllegalArgumentException("index not valid");
        }
        return this.elements[index];
    }

    public void copy(int from, int to) {
        if (from >= this.elements.length || from < 0) {
            throw new IllegalArgumentException("from index not valid");
        }
        if (to >= this.elements.length || to < 0) {
            throw new IllegalArgumentException("to index not valid");
        }
        if (from > to) {
            throw new IllegalArgumentException(from + " must be <= than " + to);
        }
        Copiable master = this.elements[from];
        if (master != null) {
            for (int i = from + 1; i <= to; ++i) {
                this.elements[i] = (Copiable)master.copy();
            }
        } else {
            for (int i = from + 1; i <= to; ++i) {
                this.elements[i] = null;
            }
        }
    }

    public Object copy() {
        CopiableArray copy = this.makeNew(this.elements.length);
        for (int i = 0; i < this.elements.length; ++i) {
            Copiable c = this.elements[i];
            if (c != null) {
                c = (Copiable)c.copy();
            }
            copy.set(c, i);
        }
        return copy;
    }
}

