/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.image.geom;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.RescaleOp;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openmicroscopy.shoola.util.ui.IconManager;
import sun.awt.image.IntegerInterleavedRaster;

public class Factory {
    public static final int IMAGE_ICON = 83;
    public static final int EXPERIMENTER_ICON = 140;
    public static final int DEFAULT_ICON_WIDTH = 16;
    public static final int DEFAULT_ICON_HEIGHT = 16;
    public static final int THUMB_DEFAULT_WIDTH = 96;
    public static final int THUMB_DEFAULT_HEIGHT = 96;
    public static final int RED_MASK = 0xFF0000;
    public static final int GREEN_MASK = 65280;
    public static final int BLUE_MASK = 255;
    public static final int BLANK_MASK = 0;
    public static final int LOC_TOP_LEFT = 0;
    public static final int LOC_TOP_RIGHT = 1;
    public static final int LOC_BOTTOM_LEFT = 2;
    public static final int LOC_BOTTOM_RIGHT = 3;
    public static final int DEFAULT_THUMB = 96;
    private static final int BORDER = 2;
    private static final String DEFAULT_TEXT = "No thumbnail";
    private static final String LOADING_TEXT = "Loading...";
    public static final int[] RGB = new int[]{0xFF0000, 65280, 255};
    public static final float[] SHARPEN = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 5.0f, -1.0f, 0.0f, -1.0f, 0.0f};
    public static final float[] LOW_PASS = new float[]{0.1f, 0.1f, 0.1f, 0.1f, 0.2f, 0.1f, 0.1f, 0.1f, 0.1f};

    private static Image scaleImage(Image src, int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D g2 = img.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setColor(Color.white);
        g2.fillRect(0, 0, width, height);
        g2.drawImage(src, 0, 0, width, height, null);
        g2.dispose();
        return img;
    }

    public static BufferedImage createDefaultImageThumbnail(int width, int height) {
        IconManager icons = IconManager.getInstance();
        ImageIcon img = null;
        if (img == null) {
            if (width == 0) {
                width = 96;
            }
            if (height == 0) {
                height = 96;
            }
            return Factory.createDefaultThumbnail(width, height, null);
        }
        int h = img.getIconHeight();
        int w = img.getIconWidth();
        if (width == 0) {
            width = 96;
        }
        if (height == 0) {
            height = 96;
        }
        BufferedImage thumbPix = new BufferedImage(width, height, 1);
        Graphics2D g = (Graphics2D)thumbPix.getGraphics();
        g.drawImage(img.getImage(), 0, 0, width, height, null);
        g.dispose();
        return thumbPix;
    }

    public static BufferedImage createDefaultImageThumbnail(int icon) {
        IconManager icons = IconManager.getInstance();
        ImageIcon img = null;
        Color background = Color.BLACK;
        switch (icon) {
            case 83: {
                background = null;
                img = icons.getImageIcon(83);
                break;
            }
            case 140: {
                background = null;
                img = icons.getImageIcon(140);
            }
        }
        if (img == null) {
            return Factory.createDefaultThumbnail(96, 96, null);
        }
        int h = img.getIconHeight();
        int w = img.getIconWidth();
        BufferedImage thumbPix = new BufferedImage(w, h, 1);
        Graphics2D g = (Graphics2D)thumbPix.getGraphics();
        if (background != null) {
            g.setBackground(background);
        }
        g.drawImage(img.getImage(), 0, 0, null);
        g.dispose();
        return thumbPix;
    }

    public static BufferedImage createDefaultThumbnail(int sizeX, int sizeY, String text) {
        BufferedImage thumbPix = new BufferedImage(sizeX, sizeY, 1);
        Graphics2D g = (Graphics2D)thumbPix.getGraphics();
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, sizeX, sizeY);
        if (text != null && text.trim().length() != 0) {
            FontMetrics fontMetrics = g.getFontMetrics();
            int xTxt = 2;
            int yTxt = sizeY / 2 - fontMetrics.getHeight();
            g.setColor(Color.WHITE);
            g.setFont(g.getFont().deriveFont(1));
            g.drawString(text, xTxt, yTxt);
            g.dispose();
        }
        return thumbPix;
    }

    public static BufferedImage createDefaultThumbnail(String text) {
        return Factory.createDefaultThumbnail(96, 96, text);
    }

    public static BufferedImage createDefaultThumbnail() {
        return Factory.createDefaultThumbnail(96, 96, LOADING_TEXT);
    }

    public static BufferedImage createDefaultThumbnail(int sizeX, int sizeY) {
        return Factory.createDefaultThumbnail(sizeX, sizeY, DEFAULT_TEXT);
    }

    public static BufferedImage magnifyImage(BufferedImage img, double level, int w) {
        if (img == null) {
            return null;
        }
        AffineTransform a = new AffineTransform();
        a.scale(level, level);
        AffineTransformOp biop = new AffineTransformOp(a, 2);
        int width = (int)((double)img.getWidth() * level) + w;
        int height = (int)((double)img.getHeight() * level) + w;
        if (width <= 0 || height <= 0) {
            return null;
        }
        BufferedImage rescaleBuff = new BufferedImage(width, height, 1);
        BufferedImage bimg = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        RescaleOp rop = new RescaleOp(1.0f, 0.0f, null);
        rop.filter(img, bimg);
        Graphics2D g = rescaleBuff.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(bimg, biop, 0, 0);
        g.dispose();
        bimg.flush();
        rescaleBuff.flush();
        System.gc();
        return rescaleBuff;
    }

    public static BufferedImage magnifyImage(double f, BufferedImage img) {
        if (img == null) {
            return null;
        }
        AffineTransform at = new AffineTransform();
        at.scale(f, f);
        int type = img.getType();
        if (type == 0) {
            type = 2;
        }
        Rectangle bounds = img.getRaster().getBounds();
        bounds = at.createTransformedShape(bounds).getBounds();
        BufferedImage rescaleBuff = img;
        rescaleBuff = new BufferedImage(bounds.width, bounds.height, type);
        Graphics2D g2 = rescaleBuff.createGraphics();
        g2.drawImage(img, at, null);
        g2.dispose();
        return rescaleBuff;
    }

    public static BufferedImage convolveImage(BufferedImage img, float[] filter) {
        if (img == null) {
            return null;
        }
        int width = img.getWidth();
        int height = img.getHeight();
        BufferedImage bimg = new BufferedImage(width, height, 1);
        RescaleOp rop = new RescaleOp(1.0f, 0.0f, null);
        rop.filter(img, bimg);
        Kernel kernel = new Kernel(3, 3, filter);
        ConvolveOp cop = new ConvolveOp(kernel, 1, null);
        BufferedImage finalImg = new BufferedImage(width, height, 1);
        cop.filter(bimg, finalImg);
        return finalImg;
    }

    public static BufferedImage createImageWithText(BufferedImage img, String text, int indexLocation, Color c) {
        if (img == null) {
            return null;
        }
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage newImage = new BufferedImage(w, h, 1);
        Graphics2D g2 = (Graphics2D)newImage.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.drawImage(img, null, 0, 0);
        FontMetrics fontMetrics = g2.getFontMetrics();
        int charWidth = fontMetrics.charWidth('m');
        int hFont = fontMetrics.getHeight();
        int length = text.length() * charWidth;
        int xTxt = 0;
        int yTxt = 0;
        switch (indexLocation) {
            case 0: {
                xTxt = 2;
                yTxt = 2 + hFont;
                break;
            }
            case 1: {
                xTxt = w - 2 - length;
                yTxt = 2 + hFont;
                break;
            }
            case 2: {
                xTxt = 2;
                yTxt = h - 2 - hFont;
                break;
            }
            case 3: {
                xTxt = w - 2 - length;
                yTxt = h - 2 - hFont;
            }
        }
        if (c != null) {
            g2.setColor(c);
            g2.setFont(g2.getFont().deriveFont(1));
            g2.drawString(text, xTxt, yTxt);
        }
        return newImage;
    }

    public static BufferedImage createImage(BufferedImage img) {
        if (img == null) {
            return null;
        }
        int sizeY = img.getWidth();
        int sizeX = img.getHeight();
        DataBufferByte buffer = new DataBufferByte(sizeX * sizeY, 3);
        DataBuffer dataBuf = img.getRaster().getDataBuffer();
        ColorModel cm = img.getColorModel();
        int pos = 0;
        int v = 0;
        for (int y = 0; y < sizeY; ++y) {
            for (int x = 0; x < sizeX; ++x) {
                pos = sizeX * y + x;
                v = dataBuf.getElem(0, pos);
                buffer.setElem(0, pos, cm.getRed(v));
                buffer.setElem(1, pos, cm.getGreen(v));
                buffer.setElem(2, pos, cm.getBlue(v));
            }
        }
        ComponentColorModel ccm = new ComponentColorModel(ColorSpace.getInstance(1000), null, false, false, 1, 0);
        BandedSampleModel csm = new BandedSampleModel(0, sizeX, sizeY, 3);
        return new BufferedImage(ccm, Raster.createWritableRaster(csm, buffer, null), false, null);
    }

    public static BufferedImage createImage(Image img) {
        if (img == null) {
            return null;
        }
        BufferedImage buff = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D gfx = buff.createGraphics();
        gfx.drawImage(img, 0, 0, null);
        gfx.dispose();
        return buff;
    }

    public static BufferedImage copyBufferedImage(BufferedImage img) {
        if (img == null) {
            return null;
        }
        BufferedImage buff = new BufferedImage(img.getWidth(null), img.getHeight(null), img.getType());
        Graphics2D gfx = buff.createGraphics();
        gfx.drawImage((Image)img, 0, 0, null);
        gfx.dispose();
        return buff;
    }

    public static BufferedImage createImage(DataBuffer buf, int bits, int sizeX, int sizeY) {
        return Factory.createImage(buf, bits, RGB, sizeX, sizeY);
    }

    public static BufferedImage createImage(DataBuffer buf, int bits, int[] masks, int sizeX, int sizeY) {
        if (buf instanceof DataBufferInt) {
            DataBufferInt j2DBuf = (DataBufferInt)buf;
            SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(3, sizeX, sizeY, sizeX, masks);
            IntegerInterleavedRaster raster = new IntegerInterleavedRaster((SampleModel)sampleModel, (DataBuffer)j2DBuf, new Point(0, 0));
            DirectColorModel colorModel = new DirectColorModel(bits, masks[0], masks[1], masks[2]);
            return new BufferedImage(colorModel, raster, false, null);
        }
        return null;
    }

    public static BufferedImage createImage(int[] buf, int bits, int sizeX, int sizeY) {
        if (buf == null) {
            return null;
        }
        DataBufferInt j2DBuf = new DataBufferInt(buf, sizeX * sizeY);
        return Factory.createImage(j2DBuf, bits, sizeX, sizeY);
    }

    public static BufferedImage createImage(int[] buf, int bits, int[] masks, int sizeX, int sizeY) {
        if (buf == null) {
            return null;
        }
        DataBufferInt j2DBuf = new DataBufferInt(buf, sizeX * sizeY);
        return Factory.createImage(j2DBuf, bits, masks, sizeX, sizeY);
    }

    public static Dimension computeThumbnailSize(int sizeX, int sizeY, double realSizeX, double realSizeY) {
        double ratio = 0.0;
        int value = 0;
        if (realSizeY != 0.0) {
            ratio = realSizeX / realSizeY;
        }
        if (sizeX <= 0 && sizeY <= 0) {
            return new Dimension(96, 96);
        }
        if (sizeX <= 0 && sizeY > 0) {
            return new Dimension(96, sizeY);
        }
        if (sizeX > 0 && sizeY <= 0) {
            return new Dimension(sizeX, 96);
        }
        if (ratio < 1.0) {
            value = (int)((double)sizeX * ratio);
            if (value != 0) {
                return new Dimension(value, sizeY);
            }
            return new Dimension(96, sizeY);
        }
        if (ratio > 1.0 && ratio != 0.0) {
            value = (int)((double)(sizeY * 1) / ratio);
            if (value != 0) {
                return new Dimension(sizeX, value);
            }
            return new Dimension(sizeX, 96);
        }
        return new Dimension(sizeX, sizeY);
    }

    public static Icon createIcon(String name, String path) {
        if (name == null || path == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(path);
        buf.append(File.separatorChar);
        buf.append(name);
        try {
            Image img = Toolkit.getDefaultToolkit().getImage(buf.toString());
            if (img == null) {
                return null;
            }
            ImageIcon icon = new ImageIcon(img);
            if (icon.getIconHeight() <= 0 || icon.getIconWidth() <= 0) {
                return null;
            }
            return icon;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Icon createIcon(String absolutePath) {
        if (absolutePath == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(absolutePath);
        try {
            Image img = Toolkit.getDefaultToolkit().getImage(buf.toString());
            if (img == null) {
                return null;
            }
            ImageIcon icon = new ImageIcon(img);
            if (icon.getIconHeight() <= 0 || icon.getIconWidth() <= 0) {
                return null;
            }
            return icon;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Icon createIcon(String absolutePath, int width, int height) {
        if (absolutePath == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(absolutePath);
        try {
            Image img = Toolkit.getDefaultToolkit().getImage(buf.toString());
            if (img == null) {
                return null;
            }
            ImageIcon icon = new ImageIcon(img);
            int w = icon.getIconWidth();
            int h = icon.getIconHeight();
            if (w <= 0 || h <= 0) {
                return null;
            }
            if (w > width && h > height) {
                return new ImageIcon(Factory.scaleImage(img, width, height));
            }
            if (w > width && h <= height) {
                double r = (double)w / (double)h;
                int value = (int)((double)w * r);
                if (value != 0) {
                    return new ImageIcon(Factory.scaleImage(img, value, height));
                }
                return new ImageIcon(Factory.scaleImage(img, width, height));
            }
            if (w <= width && h > height) {
                double r = (double)w / (double)h;
                int value = (int)((double)(h * 1) / r);
                if (value != 0) {
                    return new ImageIcon(Factory.scaleImage(img, width, value));
                }
                return new ImageIcon(Factory.scaleImage(img, width, height));
            }
            return icon;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Icon scaleIcon(Icon icon) {
        return Factory.scaleIcon(icon, 16, 16);
    }

    public static Icon scaleIcon(Icon icon, int width, int height) {
        if (icon == null) {
            return null;
        }
        if (width <= 0) {
            width = 16;
        }
        if (height <= 0) {
            height = 16;
        }
        ImageIcon img = (ImageIcon)icon;
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g = bi.createGraphics();
        g.drawImage(img.getImage(), 0, 0, width, height, null);
        return new ImageIcon(bi);
    }

    public static BufferedImage scaleBufferedImage(BufferedImage image, int width, int height) {
        if (image == null) {
            return null;
        }
        ColorModel cm = image.getColorModel();
        WritableRaster r = cm.createCompatibleWritableRaster(width, height);
        BufferedImage thumbImage = new BufferedImage(cm, r, false, null);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, width, height, null);
        return thumbImage;
    }

    public static BufferedImage scaleBufferedImage(BufferedImage image, int maxLength) {
        if (image == null) {
            return null;
        }
        int w = image.getWidth();
        int h = image.getHeight();
        if (w == maxLength && h == maxLength) {
            return image;
        }
        Dimension d = Factory.computeThumbnailSize(maxLength, maxLength, w, h);
        ColorModel cm = image.getColorModel();
        WritableRaster r = cm.createCompatibleWritableRaster(d.width, d.height);
        BufferedImage thumbImage = new BufferedImage(cm, r, false, null);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, d.width, d.height, null);
        return thumbImage;
    }

    public static BufferedImage createBandImage(DataBuffer buf, int sizeX, int sizeY, int redMask, int greenMask, int blueMask) {
        if (buf == null) {
            return null;
        }
        int[] masks = new int[]{redMask, greenMask, blueMask};
        switch (buf.getDataType()) {
            case 0: {
                DataBufferByte bufferByte = (DataBufferByte)buf;
                byte[] values = bufferByte.getData();
                int i = 0;
                int j = 0;
                int l = values.length / 3;
                int[] buffer = new int[l];
                while (i < l) {
                    buffer[i++] = values[j++] | values[j++] << 8 | values[j++] << 16;
                }
                return Factory.createImage(buffer, 24, masks, sizeX, sizeY);
            }
            case 3: {
                return Factory.createImage(buf, 32, masks, sizeX, sizeY);
            }
        }
        return null;
    }

    public static BufferedImage create(int width, int height, int[] pixels) {
        if (pixels == null) {
            return null;
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        image.setRGB(0, 0, width, height, pixels, 0, width);
        return image;
    }
}

