/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import javax.swing.table.AbstractTableModel;
import org.openmicroscopy.shoola.util.file.WriterTextCst;

public class WriterText {
    private static final String ROW = "row";
    private static final String COLUMN = "column";
    private static final String NUMBER = "num";
    private static final String VALUE = "value";

    public static void writeTableAsText(File f, AbstractTableModel table) throws Exception {
        if (table == null) {
            throw new Exception("Table cannot be null.");
        }
        BufferedWriter output = new BufferedWriter(new FileWriter(f));
        String s = "";
        String tail = "";
        int col = table.getColumnCount();
        for (int k = 0; k < col; ++k) {
            if (k < col - 1) {
                tail = ",";
            }
            s = s + table.getColumnName(k) + tail;
            tail = "";
        }
        output.write(s);
        output.newLine();
        s = "";
        for (int i = 0; i < table.getRowCount(); ++i) {
            for (int j = 0; j < col; ++j) {
                if (j < col - 1) {
                    tail = ",";
                }
                s = s + table.getValueAt(i, j) + tail;
                tail = "";
            }
            output.write(s);
            output.newLine();
            s = "";
        }
        output.close();
    }

    public static void writeTableAsXML(File f, AbstractTableModel table) throws Exception {
        if (table == null) {
            throw new Exception("Table cannot be null.");
        }
        BufferedWriter output = new BufferedWriter(new FileWriter(f));
        output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        output.newLine();
        output.write(WriterText.writeOpenTag("OME", WriterTextCst.ATTRIBUTES_ROOT, false));
        output.newLine();
        WriterText.writeTable(output, table);
        output.write(WriterText.writeCloseTag("OME"));
        output.close();
    }

    private static void writeTable(BufferedWriter output, AbstractTableModel table) throws Exception {
        HashMap<String, String> rowAttributes = new HashMap<String, String>();
        HashMap<String, String> columnAttributes = new HashMap<String, String>();
        String key = VALUE;
        for (int i = 0; i < table.getRowCount(); ++i) {
            rowAttributes.put(NUMBER, "" + i);
            output.write(WriterText.writeOpenTag(ROW, rowAttributes, false));
            output.newLine();
            for (int j = 0; j < table.getColumnCount(); ++j) {
                columnAttributes.put(NUMBER, "" + j);
                if (table.getColumnName(j) != null) {
                    key = table.getColumnName(j);
                }
                columnAttributes.put(key, "" + table.getValueAt(i, j));
                output.write(WriterText.writeOpenTag(COLUMN, columnAttributes, true));
                output.newLine();
                columnAttributes.remove(key);
            }
            output.write(WriterText.writeCloseTag(ROW));
            output.newLine();
        }
    }

    private static String writeOpenTag(String tagName, HashMap attributes, boolean emptyTag) {
        String tag = "<" + tagName;
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                String value = (String)attributes.get(key);
                tag = tag + " " + key + "=\"" + value + "\"";
            }
        }
        tag = emptyTag ? tag + "/>" : tag + ">";
        return tag;
    }

    private static String writeCloseTag(String tagName) {
        return "</" + tagName + ">";
    }
}

