/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.concur.tasks;

import org.openmicroscopy.shoola.util.concur.tasks.Invocation;
import org.openmicroscopy.shoola.util.concur.tasks.MultiStepTask;

class InvocationChainAdapter
implements MultiStepTask {
    private Invocation[] chain;
    private int step;

    InvocationChainAdapter(Invocation[] chain) {
        if (chain == null) {
            throw new NullPointerException("No call.");
        }
        if (chain.length == 0) {
            throw new IllegalArgumentException("The chain has no elements.");
        }
        this.chain = new Invocation[chain.length];
        for (int i = 0; i < chain.length; ++i) {
            this.chain[i] = chain[i];
            if (this.chain[i] != null) continue;
            throw new NullPointerException("Null element: " + i + ".");
        }
        this.step = 0;
    }

    public Object doStep() throws Exception {
        Object result = null;
        if (!this.isDone()) {
            result = this.chain[this.step++].call();
        }
        return result;
    }

    public boolean isDone() {
        return this.step == this.chain.length;
    }

    Invocation[] getChain() {
        Invocation[] c = new Invocation[this.chain.length];
        for (int i = 0; i < this.chain.length; ++i) {
            c[i] = this.chain[i];
        }
        return c;
    }
}

